import request from '@/utils/request'

/**
 * 系统备份 - 数据库导入
 * @param {*} data 
 * @returns 
 */
export function importSql(data) {
  return request({
    url: '/core/backup/importSql',
    method: 'post',
    data: data,
    headers: {
      'Content-Type': 'multipart/form-data'
    }
  })
}


/**
 * 系统备份 - 数据库导出
 * @param {*} data 
 * @returns 
 */
export function exportSql(data) {
  return request({
    url: '/core/backup/exportSql',
    method: 'post',
    data: data,
    responseType: 'blob'
  })
}
