import request from '@/utils/request'
import { pa } from 'element-plus/es/locales.mjs'

/**
 * 查询批量原始数据
 * @param {*} data 
 * @returns 
 */
export function queryBatchOriginalList(data) {
  return request({
      url: '/core/encryptionconfig/queryBatchOriginalList',
      method: 'post',
      data: data
    })
}


/**
 * 查询所有加密数据
 * @param {*} data 
 * @returns 
 */
export function queryAllEncrypted(data) {
  return request({
      url: '/core/encryptionconfig/queryAllEncrypted',
      method: 'post',
      data: data
    })
}

/**
 * 删除批量表字段
 * @param {*} data projectid
 * @returns 
 */
export function delBatchTableColumn(data) {
  return request({
      url: '/switchfield/delBatchTableColumn',
      method: 'post',
      data: data
    })
}

/**
 * 加载批量表参数
 * @param {*} data operate
 * @param {*} data projectid
 * @returns 
 */
export function loadingBatchTableParams(data) {
  return request({
      url: '/core/encryption/loadingBatchTableParams',
      method: 'post',
      data: data
    })
}

/**
 * 加载进度
 * @param {*} data 
 * @returns 
 */
export function loadingProgress(data) {
  return request({
      url: '/core/encryption/loadingProgress',
      method: 'post',
      data: data
    })
}


/**
 * 获取进度日志
 * @param {*} data 
 * @returns 
 */
export function getProcesslog(query) {
  return request({
      url: '/core/encryption/getProcesslog',
      method: 'get',
      params: query
    })
}