import request from '@/utils/request'

/**
 * 系统日志管理 - 查询月份
 * @param {*} data 
 * @returns 
 */
export function query(data) {
  return request({
    url: '/system/logconfig/query',
    method: 'post',
    data: data
  })
}

/**
 * 系统日志管理 - 保留月份
 * @param {*} data 
 * @returns 
 */
export function save(data) {
  return request({
    url: '/system/logconfig/save',
    method: 'post',
    data: data
  })
}

/**
 * 系统日志管理 - 查询日志
 * @param {*} data 
 * @returns 
 */
export function querylog(data) {
  return request({
    url: '/system/logconfig/querylog',
    method: 'post',
    data: data
  })
}

/**
 * 系统日志管理 - 下载日志
 * @param {*} data 
 * @returns 
 */
export function download(data) {
  return request({
    url: '/system/logconfig/download',
    method: 'post',
    data: data,
    responseType: 'blob'
  })
}
