import request from '@/utils/request'

/**
 * 加密规则 - 查询加密规则列表
 * @param {*} query 
 * @returns 
 */
export function query(query) {
  return request({
    url: '/core/encryption/query',
    method: 'get',
    params: query
  })
}

/**
 * 加密规则 - 查询加密方式列表
 * @param {*} query 
 * @returns 
 */
export function initEncryptionTypeList(query) {
  return request({
    url: '/core/encryption/initEncryptionTypeList',
    method: 'get',
    params: query
  })
}

/**
 * 加密规则 - 获取字典分类
 * @param {*} query 
 * @returns 
 */
export function getDictinaryTypes(query) {
  return request({
    url: '/core/dictionary/getDictinaryTypes',
    method: 'get',
    params: query
  })
}

/**
 * 加密规则 - 新增加密分类
 * @param {*} data 
 * @returns 
 */
export function save(data) {
  return request({
    url: '/core/encryption/save',
    method: 'post',
    data: data
  })
}

/**
 * 加密规则 - 删除加密分类
 * @param {*} data 
 * @returns 
 */
export function deleteType(data) {
  return request({
    url: '/core/encryption/delete',
    method: 'post',
    data: data
  })
}

/**
 * 加密规则 - 密钥生成
 * @param {*} query 
 * @returns 
 */
export function getRandomValue(query) {
  return request({
    url: '/core/encryption/getRandomValue',
    method: 'get',
    params: query
  })
}

/**
 * 加密规则 - 测试
 * @param {*} data 
 * @returns 
 */
export function testEncryption(data) {
  return request({
    url: '/core/encryption/testEncryption',
    method: 'post',
    data: data
  })
}

/**
 * 加密规则 - 新增密钥
 * @param {*} data 
 * @returns 
 */
export function saveSecretKey(data) {
  return request({
    url: '/core/encryption/saveSecretKey',
    method: 'post',
    data: data
  })
}

/**
 * 加密规则 - 删除密钥
 * @param {*} data 
 * @returns 
 */
export function delSecretKey(data) {
  return request({
    url: '/core/encryption/delSecretKey',
    method: 'post',
    data: data
  })
}

/**
 * 加密规则 - 备份导出
 * @param {*} data 
 * @returns 
 */
export function exportExcel(data) {
  return request({
    url: '/core/encryption/export',
    method: 'post',
    data: data,
    responseType: 'blob'
  })
}

/**
 * 加密规则 - 导入恢复
 * @param {*} data 
 * @returns 
 */
export function importfile(data) {
  return request({
    url: '/core/encryption/importfile',
    method: 'post',
    data: data,
    headers: {
      'Content-Type': 'multipart/form-data'
    }
  })
}