import request from '@/utils/request'

/**
 * 发现规则 - 查询数据域
 * @param {*} data 
 * @returns 
 */
export function query(data) {
  return request({
    url: '/core/searchregex/query',
    method: 'post',
    data: data
  })
}

/**
 * 发现规则 - 数据域名称是否存在
 * @param {*} query 
 * @returns 
 */
export function checkNameExitDataArea(query) {
  return request({
    url: '/core/searchregex/checkNameExitDataArea',
    method: 'get',
    params: query
  })
}

/**
 * 发现规则 - 增加数据域
 * @param {*} data 
 * @returns 
 */
export function addDataArea(data) {
  return request({
    url: '/core/searchregex/addDataArea',
    method: 'post',
    data: data
  })
}

/**
 * 发现规则 - 删除数据域
 * @param {*} data 
 * @returns 
 */
export function delDataArea(data) {
  return request({
    url: '/core/searchregex/delDataArea',
    method: 'post',
    data: data
  })
}

/**
 * 发现规则 - 获取字典分类
 * @param {*} query 
 * @returns 
 */
export function getDictinaryTypes(query) {
  return request({
    url: '/core/dictionary/getDictinaryTypes',
    method: 'get',
    params: query
  })
}


/**
 * 发现规则 - 增加规则
 * @param {*} data 
 * @returns 
 */
export function addRule(data) {
  return request({
    url: '/core/searchregex/add',
    method: 'post',
    data: data
  })
}

/**
 * 发现规则 - 删除规则
 * @param {*} data 
 * @returns 
 */
export function delRule(data) {
  return request({
    url: '/core/searchregex/del',
    method: 'post',
    data: data
  })
}

/**
 * 发现规则 - 设置默认规则
 * @param {*} data 
 * @returns 
 */
export function setdefault(data) {
  return request({
    url: '/core/searchregex/setdefault',
    method: 'post',
    data: data
  })
}

/**
 * 发现规则 - 设置测试
 * @param {*} data 
 * @returns 
 */
export function testRegex(data) {
  return request({
    url: '/core/searchregex/testRegex',
    method: 'post',
    data: data
  })
}