import router from './router'
import { ElMessage } from 'element-plus'
import NProgress, { settings } from 'nprogress'
import 'nprogress/nprogress.css'
import { getToken } from '@/utils/auth'
import { isHttp, isPathMatch } from '@/utils/validate'
import { isRelogin } from '@/utils/request'
import useUserStore from '@/store/modules/user'
import useSettingsStore from '@/store/modules/settings'
import usePermissionStore from '@/store/modules/permission'

NProgress.configure({ showSpinner: false })

const whiteList = ['/login', '/register', '/assetLibrary', '/projectHome', '/projectManage', '/classification', '/desensitizationStrategy', '/Algorithm', '/Discover', '/CalculationMethod', '/Encryption', '/Dictionary']

const isWhiteList = (path) => {
  return whiteList.some(pattern => isPathMatch(pattern, path))
}

router.beforeEach(async (to, from, next) => {
  NProgress.start()
  
  // 获取permissionStore实例
  const permissionStore = usePermissionStore()
  
  if (sessionStorage.getItem('__token') || isWhiteList(to.path)) {
    console.log('next1')
    try {
      // 检查是否已经有路由数据，避免重复设置
      if (!permissionStore.sidebarRouters || permissionStore.sidebarRouters.length === 0) {
         console.log('next2')
        // 从sessionStorage获取数据
        const allnavListStr = sessionStorage.getItem('allnavList')
        const navStatusStr = sessionStorage.getItem('navStatus')
        
        if (allnavListStr && navStatusStr) {
           console.log('next3')
          try {
            const allnavList = JSON.parse(allnavListStr)
            const navStatus = JSON.parse(navStatusStr)
            console.log('allnavList' , allnavList)
             console.log('navStatus' , navStatus)
            // 根据navStatus.type过滤菜单
            let filterMenus = []
            if (navStatus && navStatus.type) {
              let type = navStatus.type === 'manage' ? '1' : '2'
              filterMenus = allnavList.filter(item => item.type === type)
              console.log('filterMenus' , filterMenus)
            } else {
              // 默认处理，如果没有type则使用全部菜单
              filterMenus = allnavList
            }
            
            // 存入permissionStore
            if (filterMenus && filterMenus.length > 0) {
               permissionStore.setSidebarRouters(filterMenus)
              
            }
            
          } catch (parseError) {
            console.error('解析sessionStorage数据失败:', parseError)
            // 解析失败时清除无效数据
            sessionStorage.removeItem('allnavList')
            sessionStorage.removeItem('navStatus')
          }
        }
      }
      console.log(permissionStore.sidebarRouters)
      
      console.log('next6',router.getRoutes())

      next()
    } catch (error) {
      console.error('路由守卫处理失败:', error)
      next()
    }
  } else {
    next(`/login?redirect=${to.fullPath}`)
    NProgress.done()
  }
})

router.afterEach(() => {
  NProgress.done()
})