import request from '@/utils/request'
import { parseStrEmpty } from "@/utils/ruoyi"

/**
 * 密管方式列表
 * @param {*} query 
 * @returns 
 */
export function queryKeys(query) {
  return request({
    url: '/key/manager/queryKeys',
    method: 'get',
    params: query
  })
}

/**
 * 修改使用的密管方式
 */
export function editIsUse(data) {
  return request({
    url: '/key/manager/editIsUse',
    method: 'post',
    data: data
  })
}

/**
 * 参数配置
 * @param {*} query 
 * @returns 
 */
export function showKeyParams(query) {
  return request({
    url: 'key/manager/showKeyParams',
    method: 'get',
    params: query
  })
}

/**
 * 
 * @param {*} query 
 * @returns 
 */
export function testCallKey(query) {
  return request({
    url: 'key/manager/testCallKey',
    method: 'get',
    params: query
  })
}

/** * 参数配置区域
 * @param {*} data
 * @returns {string} 
 */
export function saveKeyParams(data) {
  return request({
      url: '/key/manager/saveKeyParams',
      method: 'post',
      data: data
    })
}

/**
 * 上传HSM配置
 * @param {*} formData 
 * @returns 
 */
export function uploadHsmConfig(formData) {
  return request({
    url: '/key/manager/uploadHsmConfig',
    method: 'post',
    data: formData,
    headers: {
      'Content-Type': 'multipart/form-data'
    }
  })
}

/**
 * 下载HSM配置
 * @description 该方法用于下载HSM配置文件，通常用于测试或配置验证
 * @param {Object} query - 查询参数，通常包含必要的配置或标识
 * @returns {Promise} - 返回一个Promise对象，表示下载操作的结果
 * @param {*} query 
 * @returns 
 */
export function downloadHsmConfig(query) {
  return request({
    url: 'key/manager/downloadHsmConfig',
    method: 'get',
    params: query
  })
}

/**
 * 下载CloudHsm配置
 * @description 该方法用于下载CloudHsm配置文件，通常用于测试或配置验证
 * @param {Object} query - 查询参数，通常包含必要的配置或标识
 * @returns {Promise} - 返回一个Promise对象，表示下载操作的结果
 * @param {*} query 
 * @returns 
 */
export function downloadCloudHsmConfig(query) {
  return request({
    url: 'key/manager/downloadCloudHsmConfig',
    method: 'get',
    params: query
  })
}

/**
 * 下载三维密管配置
 * @description 该方法用于下载三维密管配置文件，通常用于测试或配置验证
 * @param {Object} query - 查询参数，通常包含必要的配置或标识
 * @returns {Promise} - 返回一个Promise对象，表示下载操作的结果 
 * @param {*} query 
 * @returns 
 */
export function downloadSanWeiConfig(query) {
  return request({
    url: 'key/manager/downloadSanWeiConfig',
    method: 'get',
    params: query
  })
}

/** * 上传三维密管配置
 * @description 该方法用于上传三维密管配置文件，通常用于测试或配置验证
 * @param {Object} formData - 包含文件数据的FormData对象
 * @returns {Promise} - 返回一个Promise对象，   表示上传操作的结果
 * @param {*} formData  
 * @returns 
 */
export function uploadSanWeiConfig(formData) {
  return request({
    url: '/key/manager/uploadSanWeiConfig',
    method: 'post',
    data: formData,
    headers: {
      'Content-Type': 'multipart/form-data'
    }
  })
}

/** * 下载中电信密管配置
 * @description 该方法用于下载中电信密管配置文件，通常用于测试或配置验证
 * @param {Object} query -              查询参数，通常包含必要的配置或标识
 * @returns {Promise} - 返回一个Promise对象，表示下载操作的结果
 * @param {*} query           
 * @returns 
 */
export function downloadZdxlzjceConfig(query) {
  return request({
    url: 'key/manager/downloadZdxlzjceConfig',
    method: 'get',
    params: query
  })
}

/**
 * 国芯加密卡创建参数
 * @param {string} query 
 * @returns 
 */
export function createParam(query) {
  return request({
    url: 'key/manager/createParam',
    method: 'get',
    params: query
  })
}

