import router from '@/router'
import { ElMessageBox, } from 'element-plus'
import { login, logout, getInfo } from '@/api/login'
import { getToken, setToken, removeToken } from '@/utils/auth'
import { isHttp, isEmpty } from "@/utils/validate"
import defAva from '@/assets/images/profile.jpg'
import { sm4 as SM4 } from 'gm-crypt' 
// import useAppStore from './app'

// const appStore = useAppStore()
const useUserStore = defineStore(
  'user',
  {
    state: () => ({
      token: getToken(),
      id: '',
      name: '',
      nickName: '',
      avatar: '',
      roles: [],
      permissions: []
    }),
    actions: {
      // 登录
      login(userInfo) {
        const username = userInfo.username.trim()
        // const password = userInfo.password
        console.log('userInfo.password',userInfo.password)
         const password = this.encryptPassword(userInfo.password)
        // const code = userInfo.code
        // const uuid = userInfo.uuid
        return new Promise((resolve, reject) => {
           login(username, password).then(res => {
            console.log(res)
            if (res.code == "POP_00014"){
              
              resolve(res.data)
            }else{
                reject(error)
            }
            // return
            // setToken(res.token)
            // this.token = res.token
           reject(error)
          }).catch(error => {
            reject(error)
          })
          // login(username, password, code, uuid).then(res => {
          //   setToken(res.token)
          //   this.token = res.token
          //   resolve()
          // }).catch(error => {
          //   reject(error)
          // })
        })
      },

   

      // 加密方法
      encryptPassword(plainPassword) {
        const sm4Config = {
          key: "GJstSK_YBD=gSOFT",
          mode: 'ecb',
          cipherType: 'base64'
        }
        const sm4 = new SM4(sm4Config)
        
        try {
          return sm4.encrypt(plainPassword)
        } catch (error) {
          console.error('加密失败:', error)
          throw new Error('密码加密处理失败')
        }
      },

      // 十六进制转Base64工具方法
      hexToBase64(hexString) {
        // 将十六进制字符串转换为字节数组
        const byteArray = new Uint8Array(
          hexString.match(/.{1,2}/g).map(byte => parseInt(byte, 16))
        );
        
        // 将字节数组转换为Base64
        const base64String = btoa(
          String.fromCharCode.apply(null, byteArray)
        );
        
        return base64String;
      },
      // 获取用户信息
      getInfo() {
        return new Promise((resolve, reject) => {
          getInfo().then(res => {
            const user = res.user
            let avatar = user.avatar || ""
            if (!isHttp(avatar)) {
              avatar = (isEmpty(avatar)) ? defAva : import.meta.env.VITE_APP_BASE_API + avatar
            }
            if (res.roles && res.roles.length > 0) { // 验证返回的roles是否是一个非空数组
              this.roles = res.roles
              this.permissions = res.permissions
            } else {
              this.roles = ['ROLE_DEFAULT']
            }
            this.id = user.userId
            this.name = user.userName
            this.nickName = user.nickName
            this.avatar = avatar
            /* 初始密码提示 */
            if(res.isDefaultModifyPwd) {
              ElMessageBox.confirm('您的密码还是初始密码，请修改密码！',  '安全提示', {  confirmButtonText: '确定',  cancelButtonText: '取消',  type: 'warning' }).then(() => {
                router.push({ name: 'Profile', params: { activeTab: 'resetPwd' } })
              }).catch(() => {})
            }
            /* 过期密码提示 */
            if(!res.isDefaultModifyPwd && res.isPasswordExpired) {
              ElMessageBox.confirm('您的密码已过期，请尽快修改密码！',  '安全提示', {  confirmButtonText: '确定',  cancelButtonText: '取消',  type: 'warning' }).then(() => {
                router.push({ name: 'Profile', params: { activeTab: 'resetPwd' } })
              }).catch(() => {})
            }
            resolve(res)
          }).catch(error => {
            reject(error)
          })
        })
      },
      // 退出系统
      logOut() {
        return new Promise((resolve, reject) => {
          logout(this.token).then(() => {
            this.token = ''
            this.roles = []
            this.permissions = []
            removeToken()
            resolve()
          }).catch(error => {
            reject(error)
          })
        })
      }
    }
  })

export default useUserStore
