import request from '@/utils/request'
/**
 * 加密日志 - 查询列表数据
 * @param {*} data 
 * @returns 
 */
export function query(data) {
  return request({
    url: '/aop/encryptlog/query',
    method: 'post',
    data: data
  })
}

/**
 * 加密日志 - 校验数据
 * @param {*} data 
 * @returns 
 */
export function checkEnc(data) {
  return request({
    url: '/aop/encryptlog/checkEnc',
    method: 'post',
    data: data
  })
}

/**
 * 加密日志 - 导出下载
 * @param {*} data 
 * @returns 
 */
export function getEncryptionLogExcel(data) {
  return request({
    url: '/aop/encryptlog/getEncryptionLogExcel',
    method: 'post',
    data: data,
    responseType: 'blob'
  })
}