// import { defineStore } from 'pinia'
import Cookies from 'js-cookie'
import { useRouter } from 'vue-router'
const router = useRouter()
 const useAppStore = defineStore('app', {
  state: () => ({
    // 新版基础状态
    sidebar: {
      opened: Cookies.get('sidebarStatus') ? !!+Cookies.get('sidebarStatus') : true,
      withoutAnimation: false,
      hide: false
    },
    device: 'desktop',
    size: Cookies.get('size') || 'default',
    
    // 旧版迁移状态
    localUserName: sessionStorage.getItem('localUserName') ? JSON.parse(sessionStorage.getItem('localUserName')) : '',
    bindDataSourceInfo: sessionStorage.getItem('bindDataSourceInfo') ? JSON.parse(sessionStorage.getItem('bindDataSourceInfo')) : {},
    navList: sessionStorage.getItem('navList') ? JSON.parse(sessionStorage.getItem('navList')) : [],
    navStatus: sessionStorage.getItem('navStatus') ? JSON.parse(sessionStorage.getItem('navStatus')) : { type: 'manage' },
    leftNavActiveId: '',
    queryData: sessionStorage.getItem('queryData') ? JSON.parse(sessionStorage.getItem('queryData')) : {},
    userInfo: sessionStorage.getItem('userInfo') ? JSON.parse(sessionStorage.getItem('userInfo')) : {},
    system: sessionStorage.getItem('system') ? JSON.parse(sessionStorage.getItem('system')) : {},
    editSourcePageBackPath: sessionStorage.getItem('editSourcePageBackPath') || '',
    systemList: sessionStorage.getItem('systemList') ? JSON.parse(sessionStorage.getItem('systemList')) : [],
    navOpen: false,
    
    // 图标配置
    tableButtonIcons: {
      getInfo: {
        icon: '&#xe7d2;',
        color: "rgb(83,144,213)",
        label: "查看",
      },
      discover: {
        icon: "&#xe6e9;",
        color: "rgb(83,190,213)",
        label: "发现",
      },
      log: {
        icon: "&#xe617;",
        color: "rgb(83,190,213)",
        label: "日志",
      },
      carding: {
        icon: "&#xe661;",
        color: "rgb(83,190,213)",
        label: "梳理",
      },
      edit: {
        icon: "&#xe658;",
        color: "#0f7241",
        label: "编辑"
      },
      dele: {
        icon: "&#xe600;",
        color: "rgb(250,114,86)",
        label: "删除",
      },
      getChildrenInfo: {
        icon: "&#xe601;",
        color: "rgb(255,189,91)",
        label: "管理子任务",
      },
      showStartMaskingTaskWindow: {
        icon: "&#xe654;",
        color: "rgb(83,190,213)",
        label: "执行",
      },
      monitor: {
        icon: "&#xe622;",
        color: "rgb(79,142,212)",
        label: "监控",
      },
      statistics: {
        icon: "&#xe633;",
        color: "rgb(151,80,173)",
        label: "统计",
      },
      stopTask: {
        icon: "&#xe792;",
        color: "rgb(250,114,86)",
        label: "停止",
      },
      pauseTask: {
        icon: "&#xe6b2;",
        color: "rgb(156,89,177)",
        label: "暂停",
      },
      recoverTask: {
        icon: "&#xe69c;",
        color: "rgb(255,189,91)",
        label: "恢复",
      },
      alterTask: {
        icon: "&#xe69c;",
        color: "rgb(255,189,91)",
        label: "异常",
      },
      downloadTaskFile: {
        icon: "&#xe606;",
        color: "#5390d5",
        label: "下载",
      },
      setDate: {
        label: "", // 日期
        icon: "&#xe61d;",
        color: "rgb(83,144,213)",
      },
      openRefuseWindow: {
        icon: "&#xe645;",
        color: "rgb(250,114,86)",
        label: "拒绝",
      },
      openPassWindow: {
        icon: "&#xe7ad;",
        color: "rgb(83,144,213)",
        label: "通过",
      },
      getRowInfo: {
        icon: "&#xe6fa;",
        label: "查看列",
      },
      getFileInfo: {
        icon: "&#xe6fa;",
        label: "查看文件",
      },
      test: {
        icon: "&#xe60b;",
        color: "rgb(83, 190, 213)",
        label: "测试",
      },
      preview: {
        icon: "&#xe66c;",
        color: "#17b0a3",
        label: "预览",
      },
      AIDiscover: {
        icon: "&#xe6a0;",
        color: "#eb8787",
        label: "智能发现",
      },
      history: {
        icon: "&#xe69a;",
        color: "rgb(156,89,177)",
        label: "查看历史",
      },
      result: {
        icon: "&#xe69d;",
        color: "rgb(15, 114, 65)",
        label: "查看结果",
      }
    },
    
    // 数据库规则类型
    DBruleTypeList: [
      {
        label: '访问规则',
        value: 1
      },
      {
        label: 'SQL阻断',
        value: 2
      },
      {
        label: 'SQL替换',
        value: 3
      },
      {
        label: '表替换',
        value: 4
      },
      {
        label: '脱敏',
        value: 5
      },
      {
        label: '字段规则',
        value: 7
      },
      {
        label: '审计规则',
        value: 8
      }
    ],
    
    // 编辑映射
    EDTION_MAP: {
      equal: 0,
      notEqual: 1,
      contain: 2,
      notContain: 3
    },
    
    // 数据库图标
    DATABASE_ICONS: {
      MYSQL: {
        text: '&#xe6b3;',
        color: 'blue',
      },
      ORACLE: {
        text: '&#xe6f4;',
        color: 'red',
      },
      DB2: {
        text: '&#xe6a8;',
        color: 'red',
      },
      MSSQLSERVER: {
        text: '&#xe6b5;',
        color: 'red', 
      },
      GREENPLUM: {
        text: '&#xe857;',
        color: 'red',
      },
      REDIS: {
        text: '&#xe8b2;',
        color: 'rgb(0, 193, 222)',
      },
      MONGODB: {
        text: '&#xe6b7;',
        color: 'rgb(255, 106, 0)',
      },
      DATABASE: {
        text: '&#xe7e7;',
        color: '#E6A23C'
      },
      TABLE: {
        text: '&#xe87d;',
        color: '#008fcf'
      },
      queryTables: {
        text: '&#xe6e1;',
        color: '#f0840e'
      },
      queryViews: {
        text: '&#xe6e2;',
        color: '#f0840e'
      },
      querySynonyms: {
        text: '&#xe6e4;',
        color: '#f0840e'
      },
      DM: {
        text: '&#xe6bf;',
        color: '#f0840e'
      },
      KINGBASE: {
        text: '&#xe794;',
        color: '#2c9ef7'
      },
      GAUSS: {
        text: '&#xe795;',
        color: '#008fcf'
      },
      OCEANBASE: {
        text: '&#xe795;',
        color: '#008fcf'
      },
      ES: {
        text: '&#xe791;',
        color: ''
      }
    },
    
    // 数据库类型
    DATABASE_TYPE: ['MYSQL', 'MARIADB', 'INFORMIX', 'SYBASE', 'SYBASEIQ', 'GBASE', 'KINGBASE', 'DM', 'OSCAR', 'UXDB', 'GREENPLUM', 'TERADATA', 'HIGHGO', 'CACHE', 'OCEANBASE'],
  }),

  actions: {
    // 新版基础动作
    toggleSideBar(withoutAnimation) {
      if (this.sidebar.hide) return
      this.sidebar.opened = !this.sidebar.opened
      this.sidebar.withoutAnimation = withoutAnimation
      Cookies.set('sidebarStatus', this.sidebar.opened ? '1' : '0')
    },
    
    closeSideBar({ withoutAnimation }) {
      Cookies.set('sidebarStatus', '0')
      this.sidebar.opened = false
      this.sidebar.withoutAnimation = withoutAnimation
    },
    
    toggleDevice(device) {
      this.device = device
    },
    
    setSize(size) {
      this.size = size
      Cookies.set('size', size)
    },
    
    toggleSideBarHide(status) {
      this.sidebar.hide = status
    },
    
    // 旧版迁移动作
    setBindDataSourceInfo(data) {
      this.bindDataSourceInfo = data
      sessionStorage.setItem('bindDataSourceInfo', JSON.stringify(data))
    },
    
    setUserName(data) {
      this.localUserName = data
      sessionStorage.setItem('localUserName', JSON.stringify(data))
    },
    
    setNavStatus(data) {
      this.navStatus = data
      sessionStorage.setItem('navStatus', JSON.stringify(data))
    },
    
    setQueryData(data) {
      if (Object.prototype.toString.call(data) === '[object Object]') {
        this.queryData = data
        sessionStorage.setItem('queryData', JSON.stringify(data))
      } else {
        this.queryData = {}
        throw new Error('查询数据格式错误')
      }
    },
    
    setTableButtonIconStyle() {
      this.tableButtonIcons.getInfo.color = 'rgb(83,144,213)'
      this.tableButtonIcons.edit.color = '#0f7241'
    },
    
    setNav(data) {
      this.navList = data
      sessionStorage.setItem('navList', JSON.stringify(data))
    },
    
    setNavOpen(data) {
      this.navOpen = data
    },
    
    setSystem(data) {
      this.system = data
      sessionStorage.setItem('system', JSON.stringify(data))
    },
    
    setPath(data) {
      this.editSourcePageBackPath = data
      sessionStorage.setItem('editSourcePageBackPath', data)
    },
    
    setLeftNavActiveId(data) {
      this.leftNavActiveId = data
    },
    
    setSystemList(data) {
      this.systemList = data
      sessionStorage.setItem('systemList', JSON.stringify(data))
    },
    
    setUserInfo(data) {
      this.userInfo = data
      sessionStorage.setItem('userInfo', JSON.stringify(data))
    },
    
    async signOut(status) {
      sessionStorage.clear()
      this.system = {}
      if (status !== 'login') {
        
        await router.push({
          path: '/login'
        })
      }
    }
  }
})

export default useAppStore