import request from '@/utils/request'

/**
 * 资产库 - 查询用户列表
 * @param {*} query 
 * @returns 
 */
export function queryUser(query) {
  return request({
    url: '/console/user/queryAll',
    method: 'get',
    params: query
  })
}

/**
 * 资产库 - 查询列表
 * @param {*} query 
 * @returns 
 */
export function queryAll(query) {
  return request({
    url: '/core/datasystem/queryAll',
    method: 'get',
    params: query
  })
}

/**
 * 资产库 - 数据源明细
 * @param {*} query 
 * @returns 
 */
export function initEdit(query) {
  return request({
    url: '/core/datasystem/initEdit',
    method: 'get',
    params: query
  })
}

/**
 * 资产库 - 查询数据库版本
 * @param {*} query 
 * @returns 
 */
export function queryDatadis(query) {
  return request({
    url: '/core/datadis/queryAll',
    method: 'get',
    params: query
  })
}

/**
 * 资产库 - 数据库版本检测
 * @param {*} data 
 * @returns 
 */
export function checkVersion(data) {
  return request({
    url: '/core/datasystem/checkVersion',
    method: 'post',
    data: data
  })
}

/**
 * 资产库 - 测试数据源名称是否重复
 * @param {*} data 
 * @returns 
 */
export function checkRepeatName(data) {
  return request({
    url: '/core/datasystem/checkRepeatName',
    method: 'post',
    data: data
  })
}

/**
 * 资产库 - 测试连接
 * @param {*} data 
 * @returns 
 */
export function testConnect(data) {
  return request({
    url: '/core/datasystem/testConnect',
    method: 'post',
    data: data
  })
}

/**
 * 资产库 - 新增修改接口
 * @param {*} data 
 * @returns 
 */
export function add(data) {
  return request({
    url: '/core/datasystem/add',
    method: 'post',
    data: data
  })
}

/**
 * 资产库 - 关联检测
 * @param {*} data 
 * @returns 
 */
export function checkDatasystemUsed(data) {
  return request({
    url: '/core/datasystem/checkDatasystemUsed',
    method: 'post',
    data: data
  })
}

/**
 * 资产库 - 删除数据源
 * @param {*} data 
 * @returns 
 */
export function del(data) {
  return request({
    url: '/core/datasystem/del',
    method: 'post',
    data: data
  })
}

/**
 * 资产库 - 查询字符编码
 * @param {*} query 
 * @returns 
 */
export function queryCharset(query) {
  return request({
    url: '/core/datasystem/queryCharset',
    method: 'get',
    params: query
  })
}