import request from '@/utils/request'

/**
 * 查询数据源
 * @param {*} data project_id
 * @returns 
 * {
    "code": "POP_00014",
    "msg": "成功。",
    "totalCount": 0,
    "flag": true,
    "data": [
        {
            "dbport": "3306",
            "createtime": "2025-08-20 11:43:38",
            "flag": "1",
            "localdir": null,
            "dbip": "172.19.1.166",
            "dbservername": "ry",
            "tid": "ff80818198986db40198c5933e5902e7",
            "password": "root",
            "defaultschema": null,
            "project_id": "ec132fb8-04f0-4c0f-8460-c2a0ac4015d5",
            "sysname": "若依测试系统1",
            "dbtype": "MYSQL",
            "servername": null,
            "istargetdb": "",
            "versionname": null,
            "pagecode": "UTF8",
            "dblinkname": "若依测试系统1",
            "username": "root"
        }
    ]
}
 */
export function query(data) {
  return request({
      url: '/core/tdatasource/query',
      method: 'post',
      data: data
    })
}

/**
 * 获取分类启用状态
 * @param {*} data 
 * @returns 
 * {"code":"POP_00014","msg":"成功。","totalCount":0,"flag":true,"data":false}
 */
export function getClassifyEnable(data) {
  return request({
      url: '/core/masking/appdatarule/getClassifyEnable',
      method: 'post',
      data: data
    })
}

/**
 * 获取全局原始配置
 * @param {*} data projectId
 * @returns 
 * {"code":"POP_00014","msg":"成功。","totalCount":0,"flag":true,"data":1}
 */
export function getGlobalOriginalConfig(data) {
  return request({
      url: '/console/user/getGlobalOriginalConfig',
      method: 'post',
      data: data
    })
}

/**
 * 修改全局原始配置。是否启用解密插件
 * @param {*} data  projectId, isUse: 0|1
 * @returns 
 * {"code":"POP_00014","msg":"成功。","totalCount":0,"flag":true,"data":null}
 */
export function changeGlobalOriginalConfig(data) {
  return request({
      url: 'console/user/changeGlobalOriginalConfig',
      method: 'post',
      data: data
    })
}

/**
 * 查询数据系统基本信息
 * @param {*} data dataSystemId   projectId
 * @returns 
 * {
    "code": "POP_00014",
    "msg": "成功。",
    "totalCount": 0,
    "flag": true,
    "data": {
        "schema": "ry",
        "totalFiledNum": 225,
        "unencryptTableCount": 20,
        "port": "3306",
        "encryptTableCount": 0,
        "encryptFiledCount": 0,
        "ip": "172.19.1.166",
        "datasystemName": "若依测试系统1",
        "dbType": "MYSQL",
        "unencryptFiledCount": 225,
        "projectName": "小王"
    }
}
 */
export function queryDatasystemInfo(data) {
  return request({
      url: '/core/encryptionconfig/queryDatasystemInfo',
      method: 'post',
      data: data
    })
}



// 点击批量配置接口===============开始

/**
 * 获取敏感级别
 * @param {*} data datasystemid
 * @returns 
 * {"code":"POP_00014","msg":"成功。","totalCount":0,"flag":true,"data":[]}
 */
export function getSensitiveLevel(data) {
  return request({
      url: '/core/masking/appdatarule/getSensitiveLevel',
      method: 'post',
      data: data
    })
}


/**
 * 查询任务
 * @param {*} data projectId
 * @returns 
 * {
    "code": "POP_00014",
    "msg": "成功。",
    "totalCount": 0,
    "flag": true,
    "data": [
        {
            "value": "246049d620344e2ea44ee20c7650b96d",
            "text": "22",
            "flag": null,
            "filePath": null,
            "id": null,
            "dbType": null,
            "schmeid": null,
            "dataSystemId": null,
            "tid": null
        },
        {
            "value": "5ace9f7d2f894e9c9786bb34736033ad",
            "text": "小王",
            "flag": null,
            "filePath": null,
            "id": null,
            "dbType": null,
            "schmeid": null,
            "dataSystemId": null,
            "tid": null
        }
    ]
}
 */
export function queryTask(data) {
  return request({
      url: '/core/dataareasecretkey/queryTask',
      method: 'post',
      data: data
    })
}

/**
 * 查询任务版本
 * @param {*} data  taskid
 * @returns 
 * {
    "code": "POP_00014",
    "msg": "成功。",
    "totalCount": 0,
    "flag": true,
    "data": [
        {
            "datetime": "2025-08-23 09:16:34",
            "filename": "1234_1755940594_admin.txt",
            "versionname": "1234",
            "username": "admin"
        },
        {
            "datetime": "2025-08-23 09:16:45",
            "filename": "1_1755940605_admin.txt",
            "versionname": "1",
            "username": "admin"
        },
        {
            "datetime": "2025-08-23 09:14:51",
            "filename": "123_1755940491_admin.txt",
            "versionname": "123",
            "username": "admin"
        }
    ]
}
 */
export function queryTaskVersion(data) {
  return request({
      url: '/core/dataareasecretkey/queryTaskVersion',
      method: 'post',
      data: data
    })
}
// 点击批量配置接口===============结束

/**
 * 查询模式
 * @param {*} data dataSystemId dataType projectid
 * @returns 
 * {
    "code": "POP_00014",
    "msg": "成功。",
    "totalCount": 0,
    "flag": true,
    "data": [
        {
            "value": "ry",
            "text": "ry",
            "flag": null,
            "filePath": null,
            "id": null,
            "dbType": null,
            "schmeid": null,
            "dataSystemId": null,
            "tid": null
        }
    ]
}
 */
export function queryShemas(data) {
  return request({
      url: '/core/modifysubsettask/queryShemas',
      method: 'post',
      data: data
    })
}

/**
 * 查询表信息
 * @param {*} data dataSystemId schema（ry）
 * @returns
 * {
    "code": "POP_00014",
    "msg": "成功。",
    "totalCount": 0,
    "flag": true,
    "data": [
        {
            "realName": "gen_table",
            "showName": "gen_table"
        },
        {
            "realName": "gen_table_column",
            "showName": "gen_table_column"
        },
        {
            "realName": "sys_config",
            "showName": "sys_config"
        },
        {
            "realName": "sys_dept",
            "showName": "sys_dept"
        },
        {
            "realName": "sys_dict_data",
            "showName": "sys_dict_data"
        },
        {
            "realName": "sys_dict_type",
            "showName": "sys_dict_type"
        },
        {
            "realName": "sys_job",
            "showName": "sys_job"
        }
    ]
}
 */
export function queryTables(data) {
  return request({
      url: '/core/rowsensitivelevel/queryTables',
      method: 'post',
      data: data
    })
}

/**
 * 
 * @param {*} data dataSystemId projectId schema table
 * @returns 
 * {"code":"200","msg":"","totalCount":0,"flag":true,"data":null}
 */
export function get(data) {
  return request({
      url: '/core/tablerule/get',
      method: 'post',
      data: data
    })
}

/**
 * 
 * @param {*} data datasystem_id projectId schema table_name
 * @returns 
 * {
    "code": "POP_00014",
    "msg": "成功。",
    "totalCount": 0,
    "flag": true,
    "data": {
        "init": "display",
        "finish": "display"
    }
}
 */
export function status(data) {
  return request({
      url: '/core/udf/status',
      method: 'post',
      data: data
    })
}

/**
 * 获取表信息
 * @param {*} data dataSystemId flag=1  projectId schema tableName
 * @returns 
 * {
    "code": "POP_00014",
    "msg": "成功。",
    "totalCount": 0,
    "flag": true,
    "data": {
        "unencryptColumnCount": 21,
        "totalColumnCount": 21,
        "operator": null,
        "encryptColumnCount": 0,
        "operationTime": null
    }
}
 */
export function querytableInfo(data) {
  return request({
      url: '/core/encryptionconfig/querytableInfo',
      method: 'post',
      data: data
    })
}


/**
 * 获取表字段columnname
 * @param {*} data datasystemid schema tablename taskid
 * @returns
 * {
    "code": "POP_00014",
    "msg": "成功。",
    "totalCount": 0,
    "flag": true,
    "data": [
        {
            "primarykey": "0",
            "foreignkey": "0",
            "tablecat": "ry",
            "tableschem": null,
            "tablename": "gen_table",
            "columnname": "business_name",
            "datatype": "12",
            "typename": "VARCHAR",
            "columnsize": "30",
            "bufferlength": "65535",
            "decimaldigits": "",
            "numprecpadix": "10",
            "nullable": "1",
            "remarks": "生成业务名",
            "columndef": null,
            "sqldatatype": "0",
            "sqldatetimesub": "0",
            "charoctetlength": "30",
            "ordinalposition": "10",
            "isnullable": "YES",
            "scopecatlog": null,
            "scopeschema": null,
            "scopetable": null,
            "sourcedatatype": null,
            "isautoincrement": null,
            "scopeid": null,
            "scopeidList": null,
            "scopes": null,
            "sensitiveid": null,
            "sensitiveLevel": null,
            "columnnamehive": null,
            "dataareaName": null,
            "maskingruleid": "",
            "maskingrulename": "",
            "regextype": "",
            "targettypename": null,
            "dateTimeFormat": null,
            "secretkeyId": null,
            "secretkeyName": null,
            "datadomainId": null,
            "datadomainName": null,
            "isManual": null,
            "ischeckbox": null,
            "isDigest": null
        },
        {
            "primarykey": "0",
            "foreignkey": "0",
            "tablecat": "ry",
            "tableschem": null,
            "tablename": "gen_table",
            "columnname": "business_name_enc",
            "datatype": "-1",
            "typename": "TEXT",
            "columnsize": "65535",
            "bufferlength": "65535",
            "decimaldigits": "",
            "numprecpadix": "10",
            "nullable": "1",
            "remarks": "",
            "columndef": null,
            "sqldatatype": "0",
            "sqldatetimesub": "0",
            "charoctetlength": "65535",
            "ordinalposition": "21",
            "isnullable": "YES",
            "scopecatlog": null,
            "scopeschema": null,
            "scopetable": null,
            "sourcedatatype": null,
            "isautoincrement": null,
            "scopeid": null,
            "scopeidList": null,
            "scopes": null,
            "sensitiveid": null,
            "sensitiveLevel": null,
            "columnnamehive": null,
            "dataareaName": null,
            "maskingruleid": "",
            "maskingrulename": "",
            "regextype": "",
            "targettypename": null,
            "dateTimeFormat": null,
            "secretkeyId": null,
            "secretkeyName": null,
            "datadomainId": null,
            "datadomainName": null,
            "isManual": null,
            "ischeckbox": null,
            "isDigest": null
        },
        {
            "primarykey": "0",
            "foreignkey": "0",
            "tablecat": "ry",
            "tableschem": null,
            "tablename": "gen_table",
            "columnname": "class_name",
            "datatype": "12",
            "typename": "VARCHAR",
            "columnsize": "100",
            "bufferlength": "65535",
            "decimaldigits": "",
            "numprecpadix": "10",
            "nullable": "1",
            "remarks": "实体类名称",
            "columndef": "",
            "sqldatatype": "0",
            "sqldatetimesub": "0",
            "charoctetlength": "100",
            "ordinalposition": "6",
            "isnullable": "YES",
            "scopecatlog": null,
            "scopeschema": null,
            "scopetable": null,
            "sourcedatatype": null,
            "isautoincrement": null,
            "scopeid": null,
            "scopeidList": null,
            "scopes": null,
            "sensitiveid": null,
            "sensitiveLevel": null,
            "columnnamehive": null,
            "dataareaName": null,
            "maskingruleid": "",
            "maskingrulename": "",
            "regextype": "",
            "targettypename": null,
            "dateTimeFormat": null,
            "secretkeyId": null,
            "secretkeyName": null,
            "datadomainId": null,
            "datadomainName": null,
            "isManual": null,
            "ischeckbox": null,
            "isDigest": null
        },
        {
            "primarykey": "0",
            "foreignkey": "0",
            "tablecat": "ry",
            "tableschem": null,
            "tablename": "gen_table",
            "columnname": "create_by",
            "datatype": "12",
            "typename": "VARCHAR",
            "columnsize": "64",
            "bufferlength": "65535",
            "decimaldigits": "",
            "numprecpadix": "10",
            "nullable": "1",
            "remarks": "创建者",
            "columndef": "",
            "sqldatatype": "0",
            "sqldatetimesub": "0",
            "charoctetlength": "64",
            "ordinalposition": "16",
            "isnullable": "YES",
            "scopecatlog": null,
            "scopeschema": null,
            "scopetable": null,
            "sourcedatatype": null,
            "isautoincrement": null,
            "scopeid": null,
            "scopeidList": null,
            "scopes": null,
            "sensitiveid": null,
            "sensitiveLevel": null,
            "columnnamehive": null,
            "dataareaName": null,
            "maskingruleid": "",
            "maskingrulename": "",
            "regextype": "",
            "targettypename": null,
            "dateTimeFormat": null,
            "secretkeyId": null,
            "secretkeyName": null,
            "datadomainId": null,
            "datadomainName": null,
            "isManual": null,
            "ischeckbox": null,
            "isDigest": null
        },
        {
            "primarykey": "0",
            "foreignkey": "0",
            "tablecat": "ry",
            "tableschem": null,
            "tablename": "gen_table",
            "columnname": "create_time",
            "datatype": "93",
            "typename": "DATETIME",
            "columnsize": "19",
            "bufferlength": "65535",
            "decimaldigits": "",
            "numprecpadix": "10",
            "nullable": "1",
            "remarks": "创建时间",
            "columndef": null,
            "sqldatatype": "0",
            "sqldatetimesub": "0",
            "charoctetlength": "19",
            "ordinalposition": "17",
            "isnullable": "YES",
            "scopecatlog": null,
            "scopeschema": null,
            "scopetable": null,
            "sourcedatatype": null,
            "isautoincrement": null,
            "scopeid": null,
            "scopeidList": null,
            "scopes": null,
            "sensitiveid": null,
            "sensitiveLevel": null,
            "columnnamehive": null,
            "dataareaName": null,
            "maskingruleid": "",
            "maskingrulename": "",
            "regextype": "",
            "targettypename": null,
            "dateTimeFormat": null,
            "secretkeyId": null,
            "secretkeyName": null,
            "datadomainId": null,
            "datadomainName": null,
            "isManual": null,
            "ischeckbox": null,
            "isDigest": null
        },
        {
            "primarykey": "0",
            "foreignkey": "0",
            "tablecat": "ry",
            "tableschem": null,
            "tablename": "gen_table",
            "columnname": "function_author",
            "datatype": "12",
            "typename": "VARCHAR",
            "columnsize": "50",
            "bufferlength": "65535",
            "decimaldigits": "",
            "numprecpadix": "10",
            "nullable": "1",
            "remarks": "生成功能作者",
            "columndef": null,
            "sqldatatype": "0",
            "sqldatetimesub": "0",
            "charoctetlength": "50",
            "ordinalposition": "12",
            "isnullable": "YES",
            "scopecatlog": null,
            "scopeschema": null,
            "scopetable": null,
            "sourcedatatype": null,
            "isautoincrement": null,
            "scopeid": null,
            "scopeidList": null,
            "scopes": null,
            "sensitiveid": null,
            "sensitiveLevel": null,
            "columnnamehive": null,
            "dataareaName": null,
            "maskingruleid": "",
            "maskingrulename": "",
            "regextype": "",
            "targettypename": null,
            "dateTimeFormat": null,
            "secretkeyId": null,
            "secretkeyName": null,
            "datadomainId": null,
            "datadomainName": null,
            "isManual": null,
            "ischeckbox": null,
            "isDigest": null
        }
    ]
}
 */
export function getfield(data) {
  return request({
      url: '/core/masking/appdatarule/getfield',
      method: 'post',
      data: data
    })
}

/**
 * 
 * @param {*} data datasystem_id projectId schema table_name
 * @returns  
 *  {
    "code": "POP_00014",
    "msg": "成功。",
    "totalCount": 0,
    "flag": true,
    "data": [
        {
            "primarykey": "0",
            "foreignkey": "0",
            "tablecat": "ry",
            "tableschem": null,
            "tablename": "sys_user",
            "columnname": "login_name",
            "datatype": "12",
            "typename": "VARCHAR",
            "columnsize": "30",
            "bufferlength": "65535",
            "decimaldigits": "",
            "numprecpadix": "10",
            "nullable": "0",
            "remarks": "登录账号",
            "columndef": null,
            "sqldatatype": "0",
            "sqldatetimesub": "0",
            "charoctetlength": "30",
            "ordinalposition": "3",
            "isnullable": "NO",
            "scopecatlog": null,
            "scopeschema": null,
            "scopetable": null,
            "sourcedatatype": null,
            "isautoincrement": null,
            "scopeid": null,
            "scopeidList": null,
            "scopes": null,
            "sensitiveid": null,
            "sensitiveLevel": null,
            "columnnamehive": null,
            "dataareaName": null,
            "maskingruleid": "",
            "maskingrulename": "",
            "regextype": "",
            "targettypename": null,
            "dateTimeFormat": null,
            "secretkeyId": null,
            "secretkeyName": null,
            "datadomainId": null,
            "datadomainName": null,
            "isManual": null,
            "ischeckbox": "1",
            "isDigest": null
        },
        {
            "primarykey": "0",
            "foreignkey": "0",
            "tablecat": "ry",
            "tableschem": null,
            "tablename": "sys_user",
            "columnname": "password",
            "datatype": "12",
            "typename": "VARCHAR",
            "columnsize": "50",
            "bufferlength": "65535",
            "decimaldigits": "",
            "numprecpadix": "10",
            "nullable": "1",
            "remarks": "密码",
            "columndef": "",
            "sqldatatype": "0",
            "sqldatetimesub": "0",
            "charoctetlength": "50",
            "ordinalposition": "10",
            "isnullable": "YES",
            "scopecatlog": null,
            "scopeschema": null,
            "scopetable": null,
            "sourcedatatype": null,
            "isautoincrement": null,
            "scopeid": null,
            "scopeidList": null,
            "scopes": null,
            "sensitiveid": null,
            "sensitiveLevel": null,
            "columnnamehive": null,
            "dataareaName": null,
            "maskingruleid": "",
            "maskingrulename": "",
            "regextype": "",
            "targettypename": null,
            "dateTimeFormat": null,
            "secretkeyId": null,
            "secretkeyName": null,
            "datadomainId": null,
            "datadomainName": null,
            "isManual": null,
            "ischeckbox": null,
            "isDigest": null
        },
        {
            "primarykey": "0",
            "foreignkey": "0",
            "tablecat": "ry",
            "tableschem": null,
            "tablename": "sys_user",
            "columnname": "phonenumber",
            "datatype": "12",
            "typename": "VARCHAR",
            "columnsize": "104",
            "bufferlength": "65535",
            "decimaldigits": "",
            "numprecpadix": "10",
            "nullable": "1",
            "remarks": "手机号码",
            "columndef": null,
            "sqldatatype": "0",
            "sqldatetimesub": "0",
            "charoctetlength": "104",
            "ordinalposition": "7",
            "isnullable": "YES",
            "scopecatlog": null,
            "scopeschema": null,
            "scopetable": null,
            "sourcedatatype": null,
            "isautoincrement": null,
            "scopeid": null,
            "scopeidList": null,
            "scopes": null,
            "sensitiveid": null,
            "sensitiveLevel": null,
            "columnnamehive": null,
            "dataareaName": null,
            "maskingruleid": "",
            "maskingrulename": "",
            "regextype": "",
            "targettypename": null,
            "dateTimeFormat": null,
            "secretkeyId": null,
            "secretkeyName": null,
            "datadomainId": null,
            "datadomainName": null,
            "isManual": null,
            "ischeckbox": null,
            "isDigest": null
        }
    ]
}
 */
export function queryOriginalList(data) {
  return request({
      url: '/core/encryptionconfig/queryOriginalList',
      method: 'post',
      data: data
    })
}

/**
 * 查询加密字段列表
 * @param {*} data datasystem_id projectId schema table_name
 * @returns 
 * {
    "code": "POP_00014",
    "msg": "成功。",
    "totalCount": 0,
    "flag": true,
    "data": [
        {
            "flag": "0",
            "fieldName": "phonenumber",
            "isLike": "0",
            "secretKey": "ff8081819882f3cd019883230efc003b",
            "describe_info": null,
            "isPrimaryKey": "",
            "encryptionTypeValue": "姓名加密密钥",
            "encryptionTypeName": "姓名加密规则",
            "dataareaid": null,
            "encryptionId": "ff80818198cf9ab10198d08ac7f9019d",
            "columnType": "VARCHAR",
            "encdigit": "0",
            "encryptionIdTrue": "ff8081819882f3cd01988322cb7e0038",
            "columnSize": "104",
            "keepfirst": "1",
            "dataareaname": null
        }
    ]
}
 */
export function queryEncryptionList(data) {
  return request({
      url: '/core/encryptionconfig/queryEncryptionList',
      method: 'post',
      data: data
    })
  }


  /**
   * 计算加密后长度
   * @param {*} data 
   * columnname: "phonenumber"
   * columnsize: "104"
   * columntype: "VARCHAR"
   * datasystemid: "ff80818198986db40198c5933e5902e7"
   * dbtype: "MYSQL"
   * encryptionsecretkeyid: "ff8081819882f3cd019883230efc003b"
   * islike: "0"
   * projectid: "ec132fb8-04f0-4c0f-8460-c2a0ac4015d5"
   * tablecat: "ry"
   * tablename: "sys_user"
   * @returns
   * {  "code": "POP_00014",
   *    "msg": "成功。",
   *    "totalCount": 0,
   *    "flag": true,
   *    "data": {
   *      "extendcolumnsize": "662"
   *    }
   *  }
   */
export function queryExtendColumnSize(data) {
  return request({
      url: '/core/encryptionconfig/queryExtendColumnSize',
      method: 'post',
      data: data
    })
}

//=========== 点击字段的设置===========开始

/**
 *  查询冗余字段
 * @param {*} data datasystemid projectid schema table
 * @returns {"code":"POP_00014","msg":"成功。","totalCount":0,"flag":true,"data":null}
 */
export function hasRedundanceColumns(data) {
  return request({
      url: '/core/encryption/hasRedundanceColumns',
      method: 'post',
      data: data
    })
}

/**
 * 查询加密位数
 * @param {*} data 
 * columnname: "sex"
 * datasystemid: "ff80818198986db40198c5933e5902e7"
 * projectid: "ec132fb8-04f0-4c0f-8460-c2a0ac4015d5"
 * tablecat: "ry"
 * tablename: "sys_user"
 * @returns 
 * {
    "code": "POP_00014",
    "msg": "成功。",
    "totalCount": 0,
    "flag": true,
    "data": {
        "twoindex": "0",
        "encdigit": "0",
        "keepfirst": "0"
    }
}
 */
export function queryEncDigit(data) {
  return request({
      url: '/core/encryptionconfig/queryEncDigit',
      method: 'post',
      data: data
    })
}

/**
 * 查询
 * @param {*} data
 * columnname: "sex"
 * datasystemid: "ff80818198986db40198c5933e5902e7"
 * projectid: "ec132fb8-04f0-4c0f-8460-c2a0ac4015d5"
 * tablecat: "ry"
 * tablename: "sys_user"
 * @returns 
 * {"code":"POP_00014","msg":"成功。","totalCount":0,"flag":true,"data":"0"}
 */
export function queryIsLike(data) {
  return request({
      url: '/core/encryptionconfig/queryIsLike',
      method: 'post',
      data: data
    })
}

/**
 * 查询加密规则
 * @param {*} data encryption_name
 * @returns 
 * {
    "code": "POP_00014",
    "msg": "成功。",
    "totalCount": 0,
    "flag": true,
    "data": [
        {
            "id": "ff8081819882f3cd01988322cb7e0038",
            "flag": null,
            "note": "",
            "createtime": "2025-08-07 14:05:52",
            "updatetime": null,
            "createuser": "admin",
            "updateuser": null,
            "encryption_name": "姓名加密规则",
            "encryption_type": "AES128",
            "list": [
                {
                    "id": "ff8081819882f3cd019883230efc003b",
                    "flag": null,
                    "note": null,
                    "createtime": "2025-08-07 14:06:10",
                    "updatetime": "2025-08-21 13:21:29",
                    "createuser": "admin",
                    "updateuser": "admin",
                    "publickey": null,
                    "privatekey": null,
                    "secret_key_name": "姓名加密密钥",
                    "sectet_key_value": "1af7fa85ff7f511fa06534f669c7667d19feedd0184f87553a6be6857b06e9343adf00c2850fa86caa8055dbbde68d0b",
                    "encryption_id": "ff8081819882f3cd01988322cb7e0038",
                    "encryptionname": null
                }
            ]
        },
        {
            "id": "ff80818198cf9ab10198cfd72b2c008c",
            "flag": null,
            "note": "手机号码加密",
            "createtime": "2025-08-22 11:34:01",
            "updatetime": null,
            "createuser": "admin",
            "updateuser": null,
            "encryption_name": "手机号码加密",
            "encryption_type": "SM4_ECB",
            "list": [
                {
                    "id": "ff80818198cf9ab10198cfd77251008f",
                    "flag": null,
                    "note": null,
                    "createtime": "2025-08-22 11:34:20",
                    "updatetime": null,
                    "createuser": "admin",
                    "updateuser": null,
                    "publickey": null,
                    "privatekey": null,
                    "secret_key_name": "手机号码加密",
                    "sectet_key_value": "ec588e474702acdb67944c4999f117d4ff16b364bc6621d574729f87cdfd95c13adf00c2850fa86caa8055dbbde68d0b",
                    "encryption_id": "ff80818198cf9ab10198cfd72b2c008c",
                    "encryptionname": null
                }
            ]
        },
        {
            "id": "ff80818198cf9ab10198cfe099db0094",
            "flag": null,
            "note": "",
            "createtime": "2025-08-22 11:44:19",
            "updatetime": "2025-08-22 11:44:19",
            "createuser": "admin",
            "updateuser": "admin",
            "encryption_name": "性别加密规则",
            "encryption_type": "SM4_GCM",
            "list": []
        }
    ]
}
 */
export function encryptionQuery(data) {
  return request({
      url: '/core/encryption/query',
      method: 'get',
      data: data
    })
}


//=========== 点击字段的设置===========结束
