import request from '@/utils/request'

/**
 * 知识库 - 查询字典类型
 * @param {*} query 
 * @returns 
 */
export function dictinaryTypes(query) {
  return request({
    url: '/core/dictionary/getDictinaryTypes',
    method: 'get',
    params: query
  })
}

/**
 * 知识库 - 查询table数据
 * @param {*} data 
 * @returns 
 */
export function query(data) {
  return request({
    url: '/core/dictionary/query',
    method: 'post',
    data: data
  })
}

/**
 * 知识库 - 检测分类名称是否存在
 * @param {*} query 
 * @returns 
 */
export function checkNameExitType(query) {
  return request({
    url: '/core/dictionary/checkNameExitType',
    method: 'get',
    params: query
  })
}

/**
 * 知识库 - 添加修改分类
 * @param {*} data 
 * @returns 
 */
export function addDictionaryType(data) {
  return request({
    url: '/core/dictionary/addDictionaryType',
    method: 'post',
    data: data
  })
}

/**
 * 知识库 - 查询分类详情
 * @param {*} data 
 * @returns 
 */
export function initEditType(data) {
  return request({
    url: '/core/dictionary/initEditType',
    method: 'post',
    data: data
  })
}

/**
 * 知识库 - 删除分类
 * @param {*} data 
 * @returns 
 */
export function delDictionaryType(data) {
  return request({
    url: '/core/dictionary/delDictionaryType',
    method: 'post',
    data: data
  })
}

/**
 * 知识库 - 添加修改值
 * @param {*} data 
 * @returns 
 */
export function add(data) {
  return request({
    url: '/core/dictionary/add',
    method: 'post',
    data: data
  })
}

/**
 * 知识库 - 删除值
 * @param {*} data 
 * @returns 
 */
export function delValue(data) {
  return request({
    url: '/core/dictionary/del',
    method: 'post',
    data: data
  })
}

/**
 * 知识库 - 导出excel
 * @param {*} data 
 * @returns 
 */
export function exportExcel(data) {
  return request({
    url: '/core/dictionaryexcel/export',
    method: 'post',
    data: data,
    responseType: 'blob'
  })
}

/**
 * 知识库 - 导入
 * @param {*} data 
 * @returns 
 */
export function importfile(data) {
  return request({
    url: '/core/dictionaryexcel/importfile',
    method: 'post',
    data: data,
    headers: {
      'Content-Type': 'multipart/form-data'
    }
  })
}