import { h } from 'vue'
import {
  ElButton
} from 'element-plus'
import button from './button.module.scss'

export default function ButtonLink(props, context) {
  return h(
    ElButton,
    {
      link: true,
      type: props?.type
    },
    () => [
      h(
        'i',
        {
          class: [
            'icon-sicmp',
            props.icon,
            button['icon-sicmp']
          ]
        }
      ),
      h(
        'span',
        {
          class: button['button-text']
        },
        context.slots.default ? context.slots.default() : props.text || ''
      )
    ]
  )
}