package com.platform.springboot.controller;

import com.platform.springboot.annotation.UserLoginToken;
import com.platform.springboot.domain.ResultJson;
import com.platform.springboot.domain.dto.DepartmentPersonneDTO;
import com.platform.springboot.domain.entity.Department;
import com.platform.springboot.service.DepartmentService;
import com.platform.springboot.service.PersonnelService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

@RestController
@Api(tags = "平台部门机构信息")
@RequestMapping("/api/dt")
public class DepartmentController {

    @Resource
    private DepartmentService departmentService;
    @Resource
    private PersonnelService personnelService;

    @GetMapping(value = "/dept")
    @ApiOperation(value = "获取部门列表", notes = "获取部门列表不分页  http://ditie.wbb.aizhuanxing.com/index/jiekou/dept")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式 token", required = true, dataType = "string", paramType = "header")})
    @UserLoginToken(required = true)
    public ResultJson<List<Department>> getDeptList(HttpServletRequest request){
        List<Department> platformDepartment = departmentService.getDeptList();
        return ResultJson.ok(platformDepartment);
    }

    @GetMapping(value = "/deptByPid/{pid}")
    @ApiOperation(value = "根据部门id获取子部门列表", notes = "根据部门id获取子部门列表")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式 token", required = true, dataType = "string", paramType = "header"),
            @ApiImplicitParam(name="pid",value="部门id",required=true,paramType="path"),})
    @UserLoginToken(required = true)
    public ResultJson<List<Department>> getDeptListByPid(@PathVariable String pid, boolean deep){

        List<Department> list = null;
        if(deep){
            list = departmentService.getDeptListByPidWithDeep(pid);
        }else{
            list = departmentService.getDeptListByPid(pid);
        }
        return ResultJson.ok(list);
    }

    @GetMapping(value = "/deptByids")
    @ApiOperation(value = "通过部门id查询部门", notes = "通过部门id查询部门")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式 token", required = true, dataType = "string", paramType = "header"),
            @ApiImplicitParam(name="id",value="部门id （单一部门id或以，分割的部门id字符串））",required=true,paramType="query"),
    })
    @UserLoginToken(required = true)
    public ResultJson<List<Department>> getDeptListByIds(@RequestParam(required=true,value="id",defaultValue="")String id ){
        List<Department> list = departmentService.getDeptListByids(id);
        return ResultJson.ok(list);
    }

    @GetMapping(value = "/departmentTree")
    @ApiOperation(value = "部门级的树", notes = "部门级的树")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式 token", required = true, dataType = "string", paramType = "header"),
    })
    @UserLoginToken(required = true)
    public ResultJson<DepartmentPersonneDTO> getDepartmentTree(){
        DepartmentPersonneDTO entity = personnelService.getDepartmentTree();
        return ResultJson.ok(entity);
    }

}
