package com.platform.springboot.controller;

import com.platform.springboot.domain.ResultCode;
import com.platform.springboot.domain.ResultJson;
import com.platform.springboot.domain.entity.Todo;
import com.platform.springboot.rabbitmq.AmqpService;
import com.platform.springboot.utils.JSONUtil;
import com.platform.springboot.utils.SpringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author zhf
 */
@Slf4j
@RestController
@Api(tags = "平台待办信息")
@RequestMapping("/api/interface")
public class InterfaceController {


    @PostMapping(value = "/todo/add")
    @ApiOperation(value = "接收待办信息", notes = "接收待办信息")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),
           @ApiImplicitParam(name="todo",value="待办信息",required=true,dataType = "Todo",paramType="body"),})
    public ResultJson addtodo(@RequestBody Todo todo){
        String json = JSONUtil.toJson(todo);
        log.info("加入队列消息： "+json);
        SpringUtil.getBean(AmqpService.class).convertAndSend(json);//加入队列
        return ResultJson.ok();
    }

    @GetMapping(value = "/todo/update/{buid}")
    @ApiOperation(value = "更新待办已处理", notes = "更新待办已处理")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),
            @ApiImplicitParam(name="buid",value="业务id",required=true,dataType = "String",paramType="path"),})
    public ResultJson updatetodo(@PathVariable String buid){
        SpringUtil.getBean(AmqpService.class).convertAndSendUpdate(buid);//加入队列
        return ResultJson.ok();
    }

}
