package com.platform.springboot.domain.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.platform.springboot.domain.entity.Department;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;
@Data
@ApiModel(description= "具体参数描述")
public class DepartmentDTO {
    @ApiModelProperty(value = "展开标识")
    private boolean expand;
    @ApiModelProperty(value = "是否懒加载")
    private boolean lazy;
    @ApiModelProperty(value = "是否已加载")
    private boolean loading;
    @ApiModelProperty(value = "待办描述")
    private Integer id;
    @ApiModelProperty(value = "部门id")
    private String title;
    @ApiModelProperty(value = "部门名")
    private String pid;
    @ApiModelProperty(value = "上级部门id")
    private String label;
    @ApiModelProperty(value = "子列表")
    private List<Object> children;
    @ApiModelProperty(value = "人员子列表")
    private List<Object> people;

    public DepartmentDTO(){

    }
    public DepartmentDTO(Department department,boolean expand,boolean lazy,boolean loading){
        this.expand=expand;
        this.lazy = lazy;
        this.loading = loading;
        this.id = department.getId();
        this.title = department.getName();
        this.pid = department.getPid();
        this.label = department.getName();
        this.children = new ArrayList<>();
    }

    public DepartmentDTO(DepartmentPersonneDTO department,boolean expand,boolean lazy,boolean loading){
        this.expand=expand;
        this.lazy = lazy;
        this.loading = loading;
        this.id = department.getId();
        this.title = department.getTitle();
        this.pid = department.getPid();
        this.label = department.getLabel();
        this.children = new ArrayList<>();
    }

}
