package com.platform.springboot.service;

import com.platform.springboot.domain.dto.DepartmentPersonneDTO;
import com.platform.springboot.domain.entity.Department;
import com.platform.springboot.domain.entity.DepartmentExample;
import com.platform.springboot.mapper.DepartmentMapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
public class DepartmentServiceImpl implements DepartmentService{
    @Resource
    private DepartmentMapper departmentMapper;

    @Override
    public List<Department> getDeptList() {
        DepartmentExample example = new DepartmentExample();
        DepartmentExample.Criteria criteria = example.createCriteria();
        criteria.andStatusEqualTo("1");
        example.setOrderByClause(" id desc ");
        return departmentMapper.selectByExample(example);
    }

    /**
     * 获取子部门
     * @param pid
     * @return
     */
    public List<Department> getDeptListByPid(String pid){
        //获取组织部门
        DepartmentExample example = new DepartmentExample();
        example.setOrderByClause(" id desc ");
        example.createCriteria().andPidEqualTo(pid).andStatusEqualTo("1");
        return departmentMapper.selectByExample(example);
    }

    @Override
    public List<Department> getDeptListByPidWithDeep(String pid) {

        List<Department> departList = new ArrayList<>();
        getDeptListByPid(departList, pid);
        return departList;
    }

    private void getDeptListByPid(List<Department> departList, String pid){
        //获取组织部门
        DepartmentExample example = new DepartmentExample();
        example.setOrderByClause(" id desc ");
        example.createCriteria().andPidEqualTo(pid).andStatusEqualTo("1");
        List<Department> list = departmentMapper.selectByExample(example);
        if(list.size()>0){
            departList.addAll(list);

            for (Department depart : list) {
                getDeptListByPid(departList, depart.getId().toString());
            }
        }
    }

    @Override
    public List<Department> getDeptListByids(String id){
        List<Department> list = new ArrayList<>();
        if (id.contains(",")){
            String[] arr = id.split(",");
            for (int i = 0; i < arr.length; i++) {
                Integer in = Integer.parseInt(arr[i]);
                Department  department= departmentMapper.selectByPrimaryKey(in);
                list.add(department);
            }
            return list;
        }

        Department  department= departmentMapper.selectByPrimaryKey(Integer.parseInt(id));
        list.add(department);

        return list;
    }

}
