package com.platform.springboot.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.platform.springboot.domain.ResultJson;
import com.platform.springboot.domain.dto.*;
import com.platform.springboot.domain.entity.Department;
import com.platform.springboot.domain.entity.DepartmentExample;
import com.platform.springboot.domain.entity.Personnel;
import com.platform.springboot.domain.entity.PersonnelExample;
import com.platform.springboot.mapper.DepartmentMapper;
import com.platform.springboot.mapper.PersonnelMapper;
import com.platform.springboot.utils.JSONUtil;
import com.platform.springboot.utils.StrUtil;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
@Transactional
@Service
public class PersonnelServiceImpl implements PersonnelService {
    @Resource
    private PersonnelMapper personnelMapper;
    @Resource
    private DepartmentMapper departmentMapper;

    @Override
    public DepartmentPersonneDTO getDepartmentPersonneDTO(){
        DepartmentPersonneDTO dto = new DepartmentPersonneDTO();
        //获取所有组织部门
        DepartmentExample de = new DepartmentExample();
        DepartmentExample.Criteria criteria = de.createCriteria();
        criteria.andStatusEqualTo("1");
        de.setOrderByClause(" id asc ");
        List<DepartmentPersonneDTO> deptlist = departmentMapper.getDepartmentPersonneDTOList(de);
        //获取所有部门员工
        PersonnelExample pe = new PersonnelExample();
        pe.createCriteria().andStatusEqualTo("1");
        pe.setOrderByClause(" ordernum asc ");
        List<PersonneDTO> personnellist = personnelMapper.getDepartmentPersonneDTOList(pe);
        //构造数据
        for (int i = 0; i < deptlist.size(); i++) {
            if ("0".equals(deptlist.get(i).getPid())){
                dto = deptlist.get(i);
                break;
            }
        }
        //首先将人员放到部门下
        for (int i = 0; i < deptlist.size(); i++) {
            DepartmentPersonneDTO dtoa = deptlist.get(i);
            String id = dtoa.getId().toString();
            List<Object> childlist = new ArrayList<Object>();
            for (int k = 0; k < personnellist.size(); k++) {
                List<String> result = Arrays.asList(personnellist.get(k).getPid().split(","));
                for (int j=0;j<result.size();j++){
                    if (id.equals(result.get(j))){
                        PersonneBaseDTO baseDTO = new PersonneBaseDTO(personnellist.get(k));
                        childlist.add(baseDTO);
                        personnellist.remove(personnellist.get(k));
                        k--;
                    }
                }

            }
            dtoa.setChildren(childlist);
        }

        //将部门放在部门下
        dto = this.getDepartmentPersonneDTO(dto,deptlist);
        return dto;
    }

    @Override
    public DepartmentPersonneDTO getDepartmentPersonneDTOBranch(String branchCompanyId){
        DepartmentPersonneDTO dto = new DepartmentPersonneDTO();
        //获取所有组织部门
        DepartmentExample de = new DepartmentExample();
        DepartmentExample.Criteria criteria = de.createCriteria();
        criteria.andStatusEqualTo("1");
        criteria.andBranchCompanyidEqualTo(branchCompanyId);
        de.setOrderByClause(" id asc ");
        List<DepartmentPersonneDTO> deptlist = departmentMapper.getDepartmentPersonneDTOList(de);
        //获取所有部门员工
        PersonnelExample pe = new PersonnelExample();
        pe.createCriteria().andStatusEqualTo("1").andBranchCompanyidEqualTo(branchCompanyId);
        pe.setOrderByClause(" ordernum asc ");
        List<PersonneDTO> personnellist = personnelMapper.getDepartmentPersonneDTOList(pe);
        //构造数据
        for (int i = 0; i < deptlist.size(); i++) {
            if (branchCompanyId.equals(deptlist.get(i).getId().toString())){
                dto = deptlist.get(i);
                break;
            }
        }
        //首先将人员放到部门下
        for (int i = 0; i < deptlist.size(); i++) {
            DepartmentPersonneDTO dtoa = deptlist.get(i);
            String id = dtoa.getId().toString();
            List<Object> childlist = new ArrayList<Object>();
            for (int k = 0; k < personnellist.size(); k++) {
                List<String> result = Arrays.asList(personnellist.get(k).getPid().split(","));
                for (int j=0;j<result.size();j++){
                    if (id.equals(result.get(j))){
                        PersonneBaseDTO baseDTO = new PersonneBaseDTO(personnellist.get(k));
                        childlist.add(baseDTO);
                        personnellist.remove(personnellist.get(k));
                        k--;
                    }
                }

            }
            dtoa.setChildren(childlist);
        }

        //将部门放在部门下
        dto = this.getDepartmentPersonneDTO(dto,deptlist);
        return dto;
    }

    /**
     * 部门树不含员工
     * @param
     * @return
     */
    @Override
    public DepartmentPersonneDTO getDepartmentTree(){
        DepartmentPersonneDTO dto = new DepartmentPersonneDTO();
        //获取所有组织部门
        DepartmentExample de = new DepartmentExample();
        DepartmentExample.Criteria deprt = de.createCriteria();
        //状态为启用的部门
        deprt.andStatusEqualTo("1");
        de.setOrderByClause(" id asc ");
        List<DepartmentPersonneDTO> deptlist = departmentMapper.getDepartmentPersonneDTOList(de);

        //构造数据
        for (int i = 0; i < deptlist.size(); i++) {
            deptlist.get(i).setChildren(new ArrayList<Object>());
            if ("0".equals(deptlist.get(i).getPid())){
                dto = deptlist.get(i);
                break;
            }
        }

        //将部门放在部门下
        dto = this.getDepartmentPersonneDTO(dto,deptlist);
        return dto;
    }




    @Override
    public DepartmentPersonneDTO getDepartmentPersonneDTO2(String dept){
        DepartmentPersonneDTO dto = new DepartmentPersonneDTO();
        try {
            //获取所有组织部门
            DepartmentExample de = new DepartmentExample();
            de.setOrderByClause(" id asc ");
            DepartmentExample.Criteria criteria = de.createCriteria();
            criteria.andStatusEqualTo("1");
            List<DepartmentPersonneDTO> deptlist = departmentMapper.getDepartmentPersonneDTOList(de);
            //获取所有部门员工
            PersonnelExample pe = new PersonnelExample();
            pe.setOrderByClause(" id asc ");
            pe.createCriteria().andStatusEqualTo("1");
            List<PersonneDTO> personnellist = personnelMapper.getDepartmentPersonneDTOList(pe);

            //构造数据
            if("".equals(dept)){
                for (int i = 0; i < deptlist.size(); i++) {
                    if ("0".equals(deptlist.get(i).getPid())){
                        dto = deptlist.get(i);
                        break;
                    }
                }
            }else{
                dto = departmentMapper.selectByPrimaryKey2(Integer.parseInt(dept));
                dto.setChildren(new ArrayList<Object>());
            }

            //首先将人员放到部门下
            for (int i = 0; i < deptlist.size(); i++) {
                DepartmentPersonneDTO dtoa = deptlist.get(i);
                String id = dtoa.getId().toString();
                List<Object> childlist = new ArrayList<>();
                for (int k = 0; k < personnellist.size(); k++) {
                    List<String> result = Arrays.asList(personnellist.get(k).getPid().split(","));
                    for (int j=0;j<result.size();j++){
                        if (id.equals(result.get(j))){
                            PersonneBaseDTO baseDTO = new PersonneBaseDTO(personnellist.get(k));
                            childlist.add(baseDTO);
                            personnellist.remove(personnellist.get(k));
                            k--;
                        }
                    }
                }
                dtoa.setPeople(childlist);
                dtoa.setChildren(new ArrayList<>());
            }

            //将部门放在部门下
            dto = this.getDepartmentPersonneDTO(dto,deptlist);
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }

        return dto;
    }

    /**
     * 构造数据
     * @param dto
     * @param list
     */
    public DepartmentPersonneDTO getDepartmentPersonneDTO (DepartmentPersonneDTO dto ,List<DepartmentPersonneDTO> list){
        for (int i = 0; i < list.size(); i++) {
            if(dto.getId().toString().equals(list.get(i).getPid())){
                DepartmentPersonneDTO cu = list.get(i);
                if(dto.getChildren()==null){
                    dto.setChildren(new ArrayList<Object>());
                }
                dto.getChildren().add(cu);
                this.getDepartmentPersonneDTO(cu,list);
            }

        }
        return dto;
    }



    /**
     * 获取所有人员
     * @return
     */
    public List<Personnel> getPersonnelList(){
        PersonnelExample example = new PersonnelExample();
        return personnelMapper.selectByExample(example);
    }

    /**
     * 根据部门ID查询
     * @param dept
     * @return
     */
    @Override
    public List<Personnel> getPersonBydept(String dept){
        List<Personnel> list = new ArrayList<>();
        if(dept.contains(",")){
            String[] ds = dept.split(",");
            for (int i = 0; i < ds.length; i++) {
                    List<Personnel> l1= getPersonByonedept(ds[i]);
                list.addAll(l1);
            }
        }else{
            List<Personnel> l2= getPersonByonedept(dept);
            list.addAll(l2);
        }

        return list;
    }

    private List<Personnel> getPersonByonedept(String dept) {
        PersonnelExample example = new PersonnelExample();
        PersonnelExample.Criteria  cr =example.createCriteria();
        cr.andDepartmentEqualTo(dept);
       return  personnelMapper.selectByExample(example);
    }


    /**
     * 获取所有组织部门
     * @param account
     * @return
     */
    @Override
    public Personnel getPersonByAccount(String account){
        Personnel personnel = personnelMapper.selectByAccount(account);
        if(StringUtils.isEmpty(personnel.getDepartment())){
            return personnel;
        }
        List<String> result = Arrays.asList(personnel.getDepartment().split(","));
        AtomicReference<String> dept = new AtomicReference<>(personnel.getDepartment());
        result.forEach(t->{
            Department department= departmentMapper.selectByPrimaryKey(Integer.parseInt(t));
            if (personnel.getBranchCompanyId().equals(department.getPid())){
                dept.set(department.getId().toString());
            }else{
                dept.set(department.getPid());
            }
        });
        personnel.setCenterid(dept.toString());
        return personnel;
    }


    /**
     * 根据工号获取用户信息，多个用逗号分隔
     * @param account
     * @return
     */
    @Override
    public List<PersonneDTO> getPersonListByAccount(String account){
        List<String> accountList = Arrays.asList(account.split(","));
        PersonnelExample pe = new PersonnelExample();
        for (int i = 0; i < accountList.size(); i++) {
            pe.or().andAccountEqualTo(accountList.get(i));
        }
        pe.setOrderByClause(" id asc ");
        List<PersonneDTO> personnelList = personnelMapper.getDepartmentPersonneDTOList(pe);
        return personnelList;
    }

    /**
     * 根据工号获取用户信息(详细信息)，多个用逗号分隔
     * @param account
     * @return
     */
    @Override
    public List<PersonnelPageDTO> getPersonnelPageByAccount(String account){
        List<String> accountList = Arrays.asList(account.split(","));
        PersonnelExample pe = new PersonnelExample();
        for (int i = 0; i < accountList.size(); i++) {
            pe.or().andAccountEqualTo(accountList.get(i));
        }
        pe.setOrderByClause(" id asc ");
        List<PersonnelPageDTO>  list =personnelMapper.selectByExample2(pe);
        return list;
    }

    /**
     * 根据部门id查询用户信息
     * @param dept
     * @return
     */
    @Override
    public ResultJson getDepartmentPersonneBydept(String dept,String type){
        String flag="1";
        if (StringUtils.isEmpty(dept)){
            dept="1";
            flag="";
        }
        List<Object> list = new ArrayList<>();

        //根据部门id获取部门
        Department dt = departmentMapper.selectByPrimaryKey(Integer.parseInt(dept));
        DepartmentDTO deptDTO = new DepartmentDTO(dt,true,true,true);
        List<Object> oblist = new ArrayList<>();

        //获取部门员工
        PersonnelExample pe = new PersonnelExample();
        //PersonnelExample.Criteria pcr=pe.createCriteria();
        //pcr.andDepartmentEqualTo(dept);
        pe.or().andDepartmentLike("%,"+dept).andStatusEqualTo("1");
        pe.or().andDepartmentLike(dept+",%").andStatusEqualTo("1");
        pe.or().andDepartmentEqualTo(dept).andStatusEqualTo("1");

        pe.setOrderByClause(" ordernum,id asc ");
        List<PersonneDTO> personnellist = personnelMapper.getDepartmentPersonneDTOList(pe);
        for (int i = 0; i < personnellist.size(); i++) {
            PersonneBaseDTO baseDTO = new PersonneBaseDTO(personnellist.get(i));
            oblist.add(baseDTO);
        }
        if(!"1".equals(type)){
            //获取子级组织部门
            DepartmentExample de = new DepartmentExample();
            DepartmentExample.Criteria  cr =de.createCriteria();
            cr.andPidEqualTo(dept);
            cr.andStatusEqualTo("1");
            de.setOrderByClause(" id asc ");
            List<DepartmentPersonneDTO> deptList = departmentMapper.getDepartmentPersonneDTOList(de);
            for (int i = 0; i < deptList.size(); i++) {
                DepartmentDTO a = new DepartmentDTO(deptList.get(i),false,true,false);
                oblist.add(a);
            }
        }
        deptDTO.setChildren(oblist);
        if("".equals(flag)){
            return ResultJson.ok(deptDTO);
        }
        return ResultJson.ok(oblist);
    }

    @Override
    public PageInfo<PersonnelPageDTO> selectPersonPage(Integer pageNum, Integer pageSize, String status){
        PageHelper.startPage(pageNum, pageSize);
        PersonnelExample example = new PersonnelExample();
        example.setOrderByClause("id asc");
        List<PersonnelPageDTO>  list =("1".equals(status))?personnelMapper.selectByExample3(example):personnelMapper.selectByExample2(example);
        PageInfo<PersonnelPageDTO> pageInfo = new PageInfo<>(list);
        return pageInfo;
    }

    @Override
    public PageInfo<PersonnelPageDTO> selectPersonPageSearch(SearchDTO dto){
        Integer pageNum = dto.getPageNum();
        Integer pageSize = StringUtils.isEmpty(dto.getPageSize())?Integer.parseInt("10"):dto.getPageSize();
        String state = dto.getState();

        PageHelper.startPage(pageNum, pageSize);
        PersonnelExample example = new PersonnelExample();
        example.setOrderByClause(" a.ordernum asc ");
        PersonnelExample.Criteria  cr =example.createCriteria();
        cr.andDelstatusEqualTo("0");
        if(!StringUtils.isEmpty(dto.getPaizhu())) {
            cr.andPaizhuEqualTo(dto.getPaizhu());
        }
        if(!StringUtils.isEmpty(dto.getKey())) {
            cr.andUsernameLike('%'+dto.getKey()+'%');
        }

        PersonnelExample.Criteria  cr2 = example.createCriteria();
        if(!StringUtils.isEmpty(dto.getPaizhu())) {
            cr2.andPaizhuEqualTo(dto.getPaizhu());
        }
        if(!StringUtils.isEmpty(dto.getKey())) {
            cr2.andAccountLike('%'+dto.getKey()+'%');
        }
        cr2.andDelstatusEqualTo("0");
        example.or(cr2);


        List<PersonnelPageDTO>  list =("1".equals(state))?personnelMapper.selectByExample3(example):personnelMapper.selectByExample2(example);
        PageInfo<PersonnelPageDTO> pageInfo = new PageInfo<>(list);
        return pageInfo;
    }

    /**
     * 根据部门id查询员工及其子部门下的员工
     * @param dept
     * @return
     */
    @Override
    public List<Personnel> getAllPersonBydept(String dept,String type){
        List<Personnel> plist = new ArrayList<>();
        List<DepartmentPersonneDTO> list  = getDeptList(dept,type);
        PersonnelExample example = new PersonnelExample();
        for (int i = 0; i < list.size(); i++) {
            String t = list.get(i).getId().toString();
            example.or().andDepartmentLike("%,"+t);
            example.or().andDepartmentLike("%,"+t+",%");
            example.or().andDepartmentLike(t+",%");
            example.or().andDepartmentEqualTo(t);
        }
        example.setOrderByClause(" ordernum asc ");
        List<Personnel> allPersonnel = personnelMapper.selectByExample(example);
        for (DepartmentPersonneDTO s : list) {
            List<Personnel> persons =  allPersonnel
                    .stream()
                    .filter(item-> StrUtil.contains(item.getDepartment(),s.getId().toString())
                            && "1".equals(item.getStatus()))
                    .peek(item->item.setDepartmentname(s.getLabel()))
                    .collect(Collectors.toList());
            plist.addAll(persons);
        }
        return plist;
    }

    /**
     * 根据部门id查询员工及其子部门下的员工
     * @param dept
     * @return
     */
    @Override
    public List<Personnel> getAllPersonBydeptMatte(String dept,String type){
        List<Personnel> plist = new ArrayList<>();
        List<DepartmentPersonneDTO> list  = getDeptList(dept,type);
        PersonnelExample example = new PersonnelExample();
        for (int i = 0; i < list.size(); i++) {
            String t = list.get(i).getId().toString();
            example.or().andDepartmentLike("%,"+t);
            example.or().andDepartmentLike("%,"+t+",%");
            example.or().andDepartmentLike(t+",%");
            example.or().andDepartmentEqualTo(t);
        }
        example.setOrderByClause(" ordernum asc ");
        List<Personnel> allPersonnel = personnelMapper.selectByExample(example);
        for (DepartmentPersonneDTO s : list) {
            List<Personnel> persons =  allPersonnel
                    .stream()
                    .filter(item-> StrUtil.contains(item.getDepartment(),s.getId().toString()))
                    .peek(item->item.setDepartmentname(s.getLabel()))
                    .collect(Collectors.toList());
            plist.addAll(persons);
        }
        return plist;
    }


    /**
     * 20200925
     * 根据部门ID串，和type类型。获取最终的部门集合
     * @param depts
     * @param type
     * @return
     */
    public List<DepartmentPersonneDTO> getDeptList(String depts,String type){
        //获取所有部门
        DepartmentExample de = new DepartmentExample();
        DepartmentExample.Criteria criteria = de.createCriteria();
        criteria.andStatusEqualTo("1");
        de.setOrderByClause(" id asc ");
        List<DepartmentPersonneDTO> allDeptList = departmentMapper.getDepartmentPersonneDTOList(de);
        List<DepartmentPersonneDTO> cache =  new ArrayList<>();
        List<DepartmentPersonneDTO> currentDept = allDeptList.stream().filter(item->StrUtil.contains(depts,item.getId().toString())).collect(Collectors.toList());
        //1代表只查当前部门
        if("1".equals(type)){
            return currentDept;
        }

        //如果还要查询子部门，添加当前部门
        cache.addAll(currentDept);

        //获取参数各个部门的子部门
        List<String> deptList = Arrays.asList(depts.split(","));
        for (String dept : deptList) {
            List<DepartmentPersonneDTO > childList = getchildDeptList(dept,allDeptList);
            cache.addAll(childList);
        }
        return removeDuplicate(cache);
    }

    /**
     * 20200925
     * 获取部门的子部门集合
     * @param dept
     * @param allDeptList
     * @return
     */
    public static List<DepartmentPersonneDTO > getchildDeptList(String dept ,List<DepartmentPersonneDTO> allDeptList){
        List<DepartmentPersonneDTO> list =  new ArrayList<>();
        Stream<DepartmentPersonneDTO> stream =  allDeptList.stream().filter(item->dept.equals(item.getPid()));
        //子部门ID集合
        List<DepartmentPersonneDTO> strlist = stream.collect(Collectors.toList());
        list.addAll(strlist);
        if(strlist!=null && strlist.size()>0){
            for (DepartmentPersonneDTO childDept : strlist) {
                list.addAll(getchildDeptList(childDept.getId().toString(),allDeptList));
            }
        }
        return list;
    }


    public List<Personnel> getChildDeptPersonnel (List<Personnel> allPersonnel,List<DepartmentPersonneDTO> deptlist, List<Personnel> plist,String dept){
        for (int i = 0; i < deptlist.size(); i++) {
            DepartmentPersonneDTO deptdto = deptlist.get(i);
            if(dept.equals(deptdto.getPid())){
                String id = deptdto.getId()+"";
                for (int k = 0; k < allPersonnel.size(); k++) {
                    Personnel p = allPersonnel.get(k);
                    if(id.equals(p.getDepartment())){
                        plist.add(p);
                    }

                }
                getChildDeptPersonnel( allPersonnel,deptlist,plist,id);
            }

        }
        return plist;
    }

   @Override
   public List<PersonnelPageDTO> deptAllUser(){
       PersonnelExample example = new PersonnelExample();
       example.setOrderByClause("id asc");
        return personnelMapper.selectByExample3(example);
   }

    @Override
    public List<PersonnelPageDTO> allUser(boolean excludeDel){
        PersonnelExample example = new PersonnelExample();
        if(excludeDel){
            example.createCriteria().andDelstatusEqualTo("0").andStatusEqualTo("1");
        }
        example.setOrderByClause("id asc");
        return personnelMapper.selectByExample4(example);
    }

   @Override
   public  ResultJson getDepartmentPersonneByid(String ids,String status){
       List<PersonnelPageDTO>  list =new ArrayList<>();

       if(ids.contains(",")){
        String[] idarr = ids.split(",");
           for (int i = 0; i < idarr.length; i++) {
               Integer in = Integer.parseInt(idarr[i]);
               PersonnelPageDTO  entity =( !StringUtils.isEmpty(status))?
                       personnelMapper.selectByPrimaryKey3(in):personnelMapper.selectByPrimaryKey2(in);
               //追加工号到account字段
               if(StringUtils.isEmpty(status)){
                 entity.setAccount(entity.getNumber());
               }
               setCenter(entity);
               list.add(entity);
           }

       }else{
           Integer in = Integer.parseInt(ids);
           PersonnelPageDTO  entity =(!StringUtils.isEmpty(status))?
                   personnelMapper.selectByPrimaryKey3(in):personnelMapper.selectByPrimaryKey2(in);
           //追加工号到account字段
           if(StringUtils.isEmpty(status) && entity!=null){
               entity.setAccount(entity.getNumber());
           }
           setCenter(entity);
           if(entity!=null){
               list.add(entity);
           }
       }
       return ResultJson.ok(list);
    }

  private void setCenter(PersonnelPageDTO  entity){
      if (entity!=null){
          Map<String,String> map = getCenterIdStr(entity.getDepartment());
          entity.setCenterid(map.get("centerid"));
          entity.setCentername(map.get("centername"));
      }
    }

    @Override
    public  ResultJson getChildrenDepartmentByuserId(String userId){
        // TODO
        Integer in = Integer.parseInt(userId);
        PersonnelPageDTO  entity =personnelMapper.selectByPrimaryKey2(in);
        String deptid = entity.getDepartment();
        String[] arr = deptid.split(",");
        List<Department> cache = new ArrayList<>();
        for (int i = 0; i < arr.length; i++) {
            //默认带回本部门id
            cache.add(new Department(Integer.parseInt(arr[i]),"","","",""));
            DepartmentExample example = new DepartmentExample();
            example.setOrderByClause(" id desc ");
            example.createCriteria().andPidEqualTo(arr[i]).andStatusEqualTo("1");
            List<Department> departments = departmentMapper.selectByExample(example);
            cache.addAll(departments);
        }
        return ResultJson.ok(cache);
    }

    @Override
   public  List<Personnel> getPersonLead(String id){
        List<Personnel> leads = new ArrayList<>();
        Integer in = Integer.parseInt(id);
        Personnel  personnel = personnelMapper.selectByPrimaryKey(in);
        if(personnel==null){
            return leads;
        }
        String dept = personnel.getDepartment();//部门id
        List<String> result = Arrays.asList(dept.split(","));
        String identity = personnel.getIdentity();//身份
        //上级编码为1，普通员工为0
        if( StringUtils.isEmpty(identity) || "0".equals(identity)){
            PersonnelExample example = new PersonnelExample();
            example.setOrderByClause("id asc");
            if (result!=null&&result.size()>1){
                result.forEach(t->{
                    example.or().andDepartmentLike("%,"+t);
                    example.or().andDepartmentLike(t+",%");
                    example.or().andDepartmentEqualTo(t);
                });
            }else{
                example.or().andDepartmentLike("%,"+dept);
                example.or().andDepartmentLike(dept+",%");
                example.or().andDepartmentEqualTo(dept);
            }
            List<Personnel> list = personnelMapper.selectByExample(example);
            for (int i = 0; i < list.size(); i++) {
                Personnel p = list.get(i);
                //上级编码为1，普通员工为0
                if("1".equals(p.getIdentity())&&!p.getAccount().equals(personnel.getAccount())){
                    leads.add(p);
                }
            }
        }else{
            List<Department> dpt = new ArrayList<Department>();
            if (result!=null&&result.size()>0){
                result.forEach(t->{
                    Department department = departmentMapper.selectByPrimaryKey(Integer.parseInt(t));
                    if(department!=null){
                        dpt.add(department);
                    }
                });
                if (dpt.size()>0){
                    dpt.forEach(t->{
                        PersonnelExample example = new PersonnelExample();
                        example.setOrderByClause("id asc");
                        example.or().andDepartmentLike("%,"+t.getPid());
                        example.or().andDepartmentLike(t.getPid()+",%");
                        example.or().andDepartmentEqualTo(t.getPid());
                        List<Personnel> list = personnelMapper.selectByExample(example);
                        for (int i = 0; i < list.size(); i++) {
                            Personnel p = list.get(i);
                            //上级编码为1，普通员工为0
                            if("1".equals(p.getIdentity())){
                                leads.add(p);
                            }
                        }
                    });
                }
            }
        }

        return leads;
    }

    @Override
    public List<String> getLeveldept(String id){
        List<String> list = new ArrayList<>();
        Integer in = Integer.parseInt(id);
        Personnel  personnel = personnelMapper.selectByPrimaryKey(in);
        String dept = personnel.getDepartment();//部门id
        list.add(dept);
        List<String> result = Arrays.asList(dept.split(","));
        if(result!=null&&result.size()>0){
            result.stream().forEach(t->{
                this.getDeptPids(t,list);
            });
        }
        return removeDuplicate(list);
    }

    public List<String> getDeptPids(String dept ,List<String> list ){
        Department dpt = departmentMapper.selectByPrimaryKey(Integer.parseInt(dept));
        if(dpt!=null){
            String pid = dpt.getPid();
            list.add(pid);
            this.getDeptPids(pid,list);
        }
        return list;
    }

    /**
     * 功能描述: <br>list去除重复数据--有序
     * 〈〉
     * @Param: [list]
     * @Return: [list]
     * @Author: zhouy
     * @Date: 2019-11-07 23:37
     */

    public  List removeDuplicate(List list) {
        Set set = new HashSet();
        List newList = new ArrayList();
        for (Iterator iter = list.iterator(); iter.hasNext();) {
            Object element = iter.next();
            if (set.add(element)){
                newList.add(element);
            }
        }
        return  newList;
    }


    @Override
    public  List<Personnel> getDeptLead(String id){
       List<Personnel> deptleads = new ArrayList<>();
       Integer in = Integer.parseInt(id);
       Personnel  personnel = personnelMapper.selectByPrimaryKey(in);
       String dept = personnel.getDepartment();//部门id
        List<String> result = Arrays.asList(dept.split(","));
       PersonnelExample example = new PersonnelExample();
        example.setOrderByClause("id asc");
        if (result!=null&&result.size()>1){
            result.forEach(t->{
                example.or().andDepartmentLike("%,"+t);
                example.or().andDepartmentLike(t+",%");
                example.or().andDepartmentEqualTo(t);
            });

        }else{
            example.or().andDepartmentLike("%,"+dept);
            example.or().andDepartmentLike(dept+",%");
            example.or().andDepartmentEqualTo(dept);
        }
       List<Personnel> list = personnelMapper.selectByExample(example);
       for (int i = 0; i < list.size(); i++) {
           Personnel p = list.get(i);
           //上级编码为1，普通员工为0
           if("1".equals(p.getIdentity())&&!p.getAccount().equals(personnel.getAccount())){
               deptleads.add(p);
           }
       }return deptleads;
    }

    @Override
    public List<Personnel> getDeptFen(String id){
        List<Personnel> deptleads = new ArrayList<>();
        Integer in = Integer.parseInt(id);
        Personnel  personnel = personnelMapper.selectByPrimaryKey(in);
        //部门id
        String dept = personnel.getDepartment();
        PersonnelExample example = new PersonnelExample();
        example.createCriteria().andFuzeIsNotNull();
        example.setOrderByClause("id asc");
        List<Personnel> list = personnelMapper.selectByExample(example);

        for (int i = 0; i < list.size(); i++) {
            Personnel p = list.get(i);
            String fuze = p.getFuze();
            if(!StringUtils.isEmpty(fuze)){
                if(fuze.contains(","))
                {
                    String[] arr = fuze.split(",");
                    for (int j = 0; j < arr.length; j++) {
                        if(arr[j].equals(dept)){
                            deptleads.add(p);
                        }
                    }

                }
                else
                {
                    if(fuze.equals(dept)){
                        deptleads.add(p);
                    }
                }

            }

        }


        return deptleads;
    }

    /**
     * zhouhaifeng20200507
     * 根据部门ID获得用户的中心ID
     * @param dept
     * @return
     */

    public Map<String,String> getCenterIdStr(String dept){
        Map<String,String> res = new HashMap<>(2);
        res.put("centerid","");
        res.put("centername","");
        if (StringUtils.isEmpty(dept)){
            return res;
        }
        if(!"1".equals(dept)){
            String[] id = dept.split(",");
            List<String> result = Arrays.asList(id);
            List<String> centeridlist = new ArrayList<>();
            List<String> centerNamelist = new ArrayList<>();
            result.forEach(t->{
                String centerId = getCenter(t).getId().toString();
                String centerName = getCenter(t).getName();
                if(!StringUtils.isEmpty(centerId) && !centeridlist.contains(centerId)){//中心不空
                    centeridlist.add(centerId);
                    centerNamelist.add(centerName);
                }
            });
            String centerid = centeridlist.stream().collect(Collectors.joining(","));
            String centerName = centerNamelist.stream().collect(Collectors.joining(","));
            res.put("centerid",centerid);
            res.put("centername",centerName);

        }
        return res;
    }

    /**
     * 根据部门id返回中心
     * @param dept
     * @return
     */

    public Department getCenter(String dept){
        Integer in = Integer.parseInt(dept);
        Department dpt = departmentMapper.selectByPrimaryKey(in);

        //部门层级影响，中心往下串一级 by bajl
        Integer pin = Integer.parseInt(dpt.getPid());
        Department pdpt = departmentMapper.selectByPrimaryKey(pin);

        if("1".equals(pdpt.getPid()) || "0".equals(pdpt.getPid())){
            return dpt;
        }else{
            dpt=this.getCenter(dpt.getPid());
        }
        return dpt;
    }
    /**
     * 查询指定日期或当日人员变更记录
     * @param updatetime
     * @return
     */
    @Override
    public List<PersonnewxDTO> getpersonnellistbyday(String updatetime){
        PersonnelExample pe = new PersonnelExample();
        pe.setUpdatetime(updatetime);
        List<PersonnewxDTO>  Plist =personnelMapper.selectByExample5(pe);
        return Plist;
    }

    @Override
    public Map getCompanyIdByUserId(String userId){
        return personnelMapper.getCompanyIdByUserId(userId);
    }
}
