package com.platform.springboot.service;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.platform.springboot.domain.entity.Applications;
import com.platform.springboot.utils.DateUtil;
import org.springframework.stereotype.Service;

import java.util.Date;


/**
 * @author zhouy
 * @date 2018-07-08 21:04
 */
@Service("TokenService")
public class TokenService {
    public String getToken(Applications applications) {
        String token="";
        // 将appid 保存到 token 里面，以 secret 作为 token 的密钥
        token= JWT.create().withAudience(applications.getAppid())
                //设置过期时间24小时
                .withExpiresAt(DateUtil.addHours(new Date(), 24))
                .sign(Algorithm.HMAC256(applications.getSecret()));
        return token;
    }
}
