package com.platform.springboot.utils;

import java.util.HashMap;

/**
 * 向前台传递JSON数据
 * @author zhouy
 * @param <K>
 * @param <V>
 */
public class JSONMap<K, V>  extends HashMap<K, V> {

	private static final long serialVersionUID = -4647603063745934454L;

	@SuppressWarnings("unchecked")
	public V put(K key, V value,String valueType) {
		
		String definedStr = "";
		if(this.containsKey("JsonDef")){
			definedStr = (String)this.get("JsonDef");
		}
		definedStr+= "【"+key+"="+valueType+"】";
		super.put((K) "JsonDef", (V)definedStr);
		
		return super.put(key, value);
	}
}
