package com.platform.springboot.controller;

import com.github.pagehelper.PageInfo;
import com.platform.springboot.annotation.UserLoginToken;
import com.platform.springboot.domain.PageResult;
import com.platform.springboot.domain.ResultJson;
import com.platform.springboot.domain.dto.*;
import com.platform.springboot.domain.entity.Department;
import com.platform.springboot.domain.entity.Personnel;
import com.platform.springboot.service.PersonnelService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zhf
 */
@RestController
@Api(tags = "平台用户信息")
@RequestMapping("/api/ps")
public class PersonnelController {
    @Resource
    private PersonnelService personnelService;

    @GetMapping(value = "/account_sel/{account}")
    @ApiOperation(value = "据工号查询员工信息", notes = "据工号查询员工信息 原接口 http://ditie.wbb.aizhuanxing.com/index/jiekou/account_sel?account=1128")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),
            @ApiImplicitParam(name="account",value="工号",required=true,paramType="path"),})
    @UserLoginToken(required = true)
    public ResultJson<Personnel> getPersonByAccount(@PathVariable String account){
        Personnel entity = personnelService.getPersonByAccount(account);
        return ResultJson.ok(entity);
    }


    @GetMapping(value = "/personnels/{account}")
    @ApiOperation(value = "据工号查询员工信息(多人逗号分隔)", notes = "")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),
            @ApiImplicitParam(name="account",value="工号",required=true,paramType="path"),})
    @UserLoginToken(required = true)
    public ResultJson<Personnel> getPersonListByAccount(@PathVariable String account){
        List<PersonneDTO> list = personnelService.getPersonListByAccount(account);
        return ResultJson.ok(list);
    }

    @GetMapping(value = "/view_deptall")
    @ApiOperation(value = "获得所有部门人员（树结构）", notes = "获得所有部门人员 原接口 http://ditie.wbb.aizhuanxing.com/index/jiekou/view_deptall/")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),})
    @UserLoginToken(required = true)
    public ResultJson<DepartmentPersonneDTO> getDepartmentPersonneDTO(){
        DepartmentPersonneDTO entity = personnelService.getDepartmentPersonneDTO();
        return ResultJson.ok(entity);
    }

    @GetMapping(value = "/view_deptall/{branchCompanyId}")
    @ApiOperation(value = "获得所有部门人员（树结构）", notes = "获得所有部门人员 原接口 http://ditie.wbb.aizhuanxing.com/index/jiekou/view_deptall/")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),})
    @UserLoginToken(required = true)
    public ResultJson<DepartmentPersonneDTO> getDepartmentPersonneDTOBranch(@PathVariable String branchCompanyId){
        DepartmentPersonneDTO entity = null;
        if("null".equals(branchCompanyId)){
            entity = personnelService.getDepartmentPersonneDTO();
        }else{
            entity = personnelService.getDepartmentPersonneDTOBranch(branchCompanyId);
        }
        return ResultJson.ok(entity);
    }


    @GetMapping(value = "/dept_all")
    @ApiOperation(value = "获取全部部门以及部门下的人员", notes = "获取全部部门以及部门下的人员http://ditie.wbb.aizhuanxing.com/index/jiekou/dept_all")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),})
    @UserLoginToken(required = true)
    public ResultJson<DepartmentPersonneDTO> getDepartmentPersonneDTO2(){
        DepartmentPersonneDTO entity = personnelService.getDepartmentPersonneDTO2("");
        return ResultJson.ok(entity);
    }


    @GetMapping(value = "/personnel")
    @ApiOperation(value = "根据部门id查询用户信息(人员简化-树结构懒加载)", notes = "根据部门id查询用户信息 原接口http://ditie.wbb.aizhuanxing.com/index/jiekou/personnel?dept=")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),
            @ApiImplicitParam(name="dept",value="部门id",paramType="query"),
            @ApiImplicitParam(name="type",value="1查询单一部门人员,2查询部门人员及部門下级部门",paramType="query"),
    })
    @UserLoginToken(required = true)
    public ResultJson getDepartmentPersonneBydept(
            @RequestParam(required=true,value="dept",defaultValue="") String dept,
            @RequestParam(required=true,value="type",defaultValue="") String type
    ){
        return personnelService.getDepartmentPersonneBydept(dept,type);
    }

//    @GetMapping(value = "/personnel")
//    public ResultJson getDepartmentPersonne(){
//        return personnelService.getDepartmentPersonneBydept("");
//    }

    @GetMapping(value = "/dept_user/{dept}")
    @ApiOperation(value = "根据部门id查询员工", notes = "根据部门id查询：原接口 http://ditie.wbb.aizhuanxing.com/index/jiekou/dept_user?id=8")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),
            @ApiImplicitParam(name="dept",value="部门id",required=true,paramType="path"),})
    @UserLoginToken(required = true)
    public ResultJson<List<Personnel>> getPersonBydept(@PathVariable String dept){
        List<Personnel> list = personnelService.getPersonBydept(dept);
        return ResultJson.ok(list);
    }


    @GetMapping(value = "/users")
    @ApiOperation(value = "查询所有员工接口", notes = "查询所有员工接口 http://ditie.wbb.aizhuanxing.com/index/jiekou/users?page=1&limit=8000&state=1")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),
            @ApiImplicitParam(name="pageNum",value="页码",paramType="query"),
            @ApiImplicitParam(name="pageSize",value="每页条数",paramType="query"),
            @ApiImplicitParam(name="status",value="1",paramType="query"),})
    @UserLoginToken(required = true)
    public ResultJson<PageResult< List<PersonnelPageDTO>>> adminIndex(@RequestParam(required=true,value="pageNum",defaultValue="1") Integer pageNum,
                             @RequestParam(required=true,value="pageSize",defaultValue="15") Integer pageSize,
                                 @RequestParam(required=true,value="status",defaultValue="1")String status
    ){
        PageInfo<PersonnelPageDTO> page = personnelService.selectPersonPage(pageNum,pageSize,status);
        PageResult< List<PersonnelPageDTO>>  pr = new PageResult();
        pr.setData(page.getList());
        pr.setTotal(page.getTotal());
        pr.setCurrent_page(page.getPageNum());
        pr.setLast_page(page.getPages());
        pr.setPer_page(page.getSize()+"");
        return ResultJson.ok(pr);
    }

    @GetMapping(value = "/userscreen")
    @ApiOperation(value = "根据部门id查询员工及其子部门下的员工(多部门用逗号“,”分隔)", notes = "根据部门id查询员工及其子部门下的员工http://ditie.wbb.aizhuanxing.com/index/jiekou/userscreen")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),
            @ApiImplicitParam(name="dept",value="部门id",required=true,paramType="query"),
            @ApiImplicitParam(name="type",value="1查询单一部门人员,2查询所有下级部门人员.type字段不存在时，查询所有人员",required=false,paramType="query"),
    })
    @UserLoginToken(required = true)
    public ResultJson<List<Personnel>> getAllPersonBydept(
            @RequestParam(required=true,value="dept",defaultValue="") String dept,
            @RequestParam(required=true,value="type",defaultValue="") String type
    ){
        List<Personnel> list = personnelService.getAllPersonBydept(dept,type);
        return ResultJson.ok(list);
    }

    @GetMapping(value = "/userscreenMatte")
    @UserLoginToken(required = true)
    public ResultJson<List<Personnel>> userscreenMatte(
            @RequestParam(required=true,value="dept",defaultValue="") String dept,
            @RequestParam(required=true,value="type",defaultValue="") String type
    ){
        List<Personnel> list = personnelService.getAllPersonBydeptMatte(dept,type);
        return ResultJson.ok(list);
    }


    /**
     * http://ditie.wbb.aizhuanxing.com/index/jiekou/user_depe
     */
    @GetMapping(value = "/user_depe")
    @ApiOperation(value = "获取全部用户并且匹配部门", notes = "获取全部用户并且匹配部门 http://ditie.wbb.aizhuanxing.com/index/jiekou/user_depe")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),})
    @UserLoginToken(required = true)
    public ResultJson< List<PersonnelPageDTO>> deptAllUser(){
        List<PersonnelPageDTO> list = personnelService.deptAllUser();
        return ResultJson.ok(list);
    }

    /**
     * zhouhaifeng
     * 20200321
     * @return
     */
    @GetMapping(value = "/allUser")
    @ApiOperation(value = "获取全部用户(单纯的列表)", notes = "获取全部用户(单纯的列表)")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),})
    @UserLoginToken(required = true)
    public ResultJson< List<PersonnelPageDTO>> allUser(boolean excludeDel){
        List<PersonnelPageDTO> list = personnelService.allUser(excludeDel);
        return ResultJson.ok(list);
    }

    @GetMapping(value = "/users_one")
    @ApiOperation(value = "通过id查询用户", notes = "通过id查询用户http://ditie.aizhuanxing.com/index/jiekou/users_one")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),
            @ApiImplicitParam(name="id",value="用户id （单一用户id或以，分割的用户id字符串）",required=true,paramType="query"),
            @ApiImplicitParam(name="state",value="字段限制（没有此字段，会限制获取的信息）",required=false,paramType="query"),
    })
    @UserLoginToken(required = true)
    public ResultJson< List<PersonnelPageDTO>> getDepartmentPersonneByid(
            @RequestParam(required=true,value="id",defaultValue="")String id ,
            @RequestParam(required=false,value="state",defaultValue="")String state){
        return  personnelService.getDepartmentPersonneByid(id,state);
    }

    @GetMapping(value = "/child_dept")
    @ApiOperation(value = "通过用户id查询下属部门", notes = "")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),
            @ApiImplicitParam(name="id",value="用户id",required=true,paramType="query")
    })
    @UserLoginToken(required = true)
    public ResultJson< List<Department>> getChildrenDepartmentByuserId(@RequestParam(required=true,value="id",defaultValue="")String id ){
        return  personnelService.getChildrenDepartmentByuserId(id);
    }


    @GetMapping(value = "/lead/{id}")
    @ApiOperation(value = "获取当前人员上级(普通员工获取部门领导，部门领导获取上级部门领导)",
            notes = "获取当前人员上级(普通员工获取部门领导，部门领导获取上级部门领导)http://ditie.wbb.aizhuanxing.com/index/jiekou/lead")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),
            @ApiImplicitParam(name="id",value="用户id",required=true,paramType="path"),
    })
    @UserLoginToken(required = true)
    public ResultJson< List<Personnel>> getPersonLead(@PathVariable String id){
        List<Personnel> list = personnelService.getPersonLead(id);
        return ResultJson.ok(list);
    }

    @GetMapping(value = "/level_dept/{uid}")
    @ApiOperation(value = "获取当前人员全部上级部门",
            notes = "获取当前人员全部上级部门http://ditie.wbb.aizhuanxing.com/index/jiekou/level_dept")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),
            @ApiImplicitParam(name="uid",value="用户uid",required=true,paramType="path"),
    })
    @UserLoginToken(required = true)
    public ResultJson<List<String>> getLeveldept(@PathVariable String uid){
        List<String> list = personnelService.getLeveldept(uid);
        return ResultJson.ok(list);
    }

    @GetMapping(value = "/user_down/{dept_id}")
    @ApiOperation(value = "通过部门id查询所有下级",
            notes = "通过部门id查询所有下级http://ditie.wbb.aizhuanxing.com/index/jiekou/user_down")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),
            @ApiImplicitParam(name="dept_id",value="部门id",required=true,paramType="path"),
    })
    @UserLoginToken(required = true)
    public ResultJson<DepartmentPersonneDTO> getUserDown(@PathVariable String dept_id){
        DepartmentPersonneDTO entity = personnelService.getDepartmentPersonneDTO2(dept_id);
        return ResultJson.ok(entity.getChildren());
    }

    @GetMapping(value = "/dept_lingdao/{uid}")
    @ApiOperation(value = "当前人员的部门领导",
            notes = "当前人员的部门领导http://ditie.wbb.aizhuanxing.com/index/jiekou/dept_lingdao")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),
            @ApiImplicitParam(name="uid",value="用户id",required=true,paramType="path"),
    })
    @UserLoginToken(required = true)
    public ResultJson< List<Personnel>> getDeptLead(@PathVariable String uid){
        List<Personnel> list = personnelService.getDeptLead(uid);
        return ResultJson.ok(list);
    }


    @GetMapping(value = "/dept_fen/{uid}")
    @ApiOperation(value = "查询分管领导",
            notes = "查询分管领导http://ditie.wbb.aizhuanxing.com/index/jiekou/dept_fen")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),
            @ApiImplicitParam(name="uid",value="用户id",required=true,paramType="path"),
    })
    @UserLoginToken(required = true)
    public ResultJson< List<Personnel>> getDeptFen(@PathVariable String uid){
        List<Personnel> list = personnelService.getDeptFen(uid);
        return ResultJson.ok(list);
    }


    @PostMapping(value = "/search")
    @ApiOperation(value = "通过姓名和工号搜索", notes = "通过姓名和工号搜索http://ditie.wbb.aizhuanxing.com/index/jiekou/search")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),
            @ApiImplicitParam(name="searchDTO",value="",required=true,dataType = "SearchDTO",paramType="body"),})
    @UserLoginToken(required = true)
    public ResultJson<PageResult< List<PersonnelPageDTO>>> selectPersonPageSearch(@RequestBody SearchDTO searchDTO){
        PageInfo<PersonnelPageDTO> page = personnelService.selectPersonPageSearch(searchDTO);
        PageResult< List<PersonnelPageDTO>>  pr = new PageResult();
        pr.setData(page.getList());
        pr.setTotal(page.getTotal());
        pr.setCurrent_page(page.getPageNum());
        pr.setLast_page(page.getPages());
        pr.setPer_page(page.getSize()+"");
        return ResultJson.ok(pr);
    }

    /**
     * @author zhf
     * @time 20200925
     * @param account
     * @return
     */
    @GetMapping(value = "/personnelsDetail/{account}")
    @ApiOperation(value = "据工号查询员工(详细信息)信息(多人逗号分隔)", notes = "")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),
            @ApiImplicitParam(name="account",value="工号",required=true,paramType="path"),})
    @UserLoginToken(required = true)
    public ResultJson<List<PersonnelPageDTO>> getPersonnelPageByAccount(@PathVariable String account){
        List<PersonnelPageDTO> list = personnelService.getPersonnelPageByAccount(account);
        return ResultJson.ok(list);
    }
    /**
     * 查询指定日期或当日人员变更记录
     */
    @GetMapping(value = "/getpersonnellistbyday/{updatetime}")
    @ApiOperation(value = "查询指定日期或当日人员变更记录", notes = "")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),
    @ApiImplicitParam(name = "updatetime", value = "日期 如 2021-05-18", required = true, dataType = "string", paramType = "path")})
    @UserLoginToken(required = true)
    public ResultJson<List<PersonnewxDTO>> getpersonnellistbyday(@PathVariable String updatetime){
        List<PersonnewxDTO> list = personnelService.getpersonnellistbyday(updatetime);
        return ResultJson.ok(list);
    }

    /**
     * @description: 通过userID查branchCompanyId
     * @author bajl
     * @date 2024/6/25 14:00
     */
    @GetMapping(value = "/getCompanyIdByUserId/{userId}")
    @ApiOperation(value = "通过userID查branchCompanyId", notes = "")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),
            @ApiImplicitParam(name="userId",value="用户id",required=true,paramType="path")})
    @UserLoginToken(required = true)
    public ResultJson<Map> getCompanyIdByUserId(@PathVariable String userId){

        Map company = personnelService.getCompanyIdByUserId(userId);
        return ResultJson.ok(company);
    }
}
