package com.platform.springboot.domain.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel(description= "具体参数描述")
public class Todo implements Serializable {
    /**
     *   待办描述
     */
    @ApiModelProperty(value = "待办描述",required=true)
    private String memo;
    /**
     *   业务类型
     */
    @ApiModelProperty(value = "业务类型(接受值为1,2,3,4 [1=会议系统,2 =日报系统,3 =安全生产管理系统,4= 考勤系统]）",required=true)
    private String type;
    /**
     *   业务id
     */
    @ApiModelProperty(value = "业务id",required=true)
    private String buid;
    /**
     *   待办人工号
     */
    @ApiModelProperty(value = "待办人工号",required=true)
    private String account;

    /**
     *   跳转路由
     */
    @ApiModelProperty(value = "跳转路由",required=true)
    private String rounter;


}