package com.platform.springboot.rabbitmq;

/**
 * .::::.
 * .::::::::.
 * :::::::::::    佛主保佑、永无Bug
 * ..:::::::::::'
 * '::::::::::::'
 * .::::::::::
 * '::::::::::::::..
 * ..::::::::::::.
 * ``::::::::::::::::
 * ::::``:::::::::'        .:::.
 * ::::'   ':::::'       .::::::::.
 * .::::'      ::::     .:::::::'::::.
 * .:::'       :::::  .:::::::::' ':::::.
 * .::'        :::::.:::::::::'      ':::::.
 * .::'         ::::::::::::::'         ``::::.
 * ...:::           ::::::::::::'              ``::.
 * ```` ':.          ':::::::::'                  ::::..
 * '.:::::'                    ':'````..
 */

/**
 * @ClassName: RabbitExchangeConfig
 * @Description: ${description}
 * @Authror zhouy
 * @Date 2019-08-28 21:56
 */
import org.springframework.amqp.core.*;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RabbitExchangeConfig {
    @Autowired
    private RabbitAdmin rabbitAdmin;

    public RabbitExchangeConfig() {
    }

    //广播模式
    @Bean
    FanoutExchange contractFanoutExchange() {
        FanoutExchange fanoutExchange = new FanoutExchange("com.exchange.fanout");
        this.rabbitAdmin.declareExchange(fanoutExchange);
        return fanoutExchange;
    }

    @Bean
    TopicExchange contractTopicExchangeDurable() {
        TopicExchange contractTopicExchange = new TopicExchange("com.exchange.topic");
        this.rabbitAdmin.declareExchange(contractTopicExchange);
        return contractTopicExchange;
    }

    @Bean
    DirectExchange contractDirectExchange() {
        DirectExchange contractDirectExchange = new DirectExchange("com.exchange.direct");
        this.rabbitAdmin.declareExchange(contractDirectExchange);
        return contractDirectExchange;
    }

    //创建新增代办信息队列
    @Bean
    Queue queueAddTodo() {
        Queue queue = new Queue("com.queue.notify.addtodo", true);
        this.rabbitAdmin.declareQueue(queue);
        return queue;
    }
    //创建更新代办信息队列
    @Bean
    Queue queueUpdateTodo() {
        Queue queue = new Queue("com.queue.notify.updatetodo", true);
        this.rabbitAdmin.declareQueue(queue);
        return queue;
    }

    //创建更新代办信息队列
    @Bean
    Queue queueHello() {
        Queue queue = new Queue("com.queue.notify.hello", true);
        this.rabbitAdmin.declareQueue(queue);
        return queue;
    }

    //队列交换机绑定
    @Bean
    Binding bindingAddDirect() {
        return BindingBuilder.bind(queueAddTodo()).to(contractDirectExchange()).with("CalonDirectRouting");
    }

    //队列交换机绑定
    @Bean
    Binding bindingUpdateDirect() {
        return BindingBuilder.bind(queueUpdateTodo()).to(contractDirectExchange()).with("CalonDirectRoutingUpdate");
    }

    //队列交换机绑定
    @Bean
    Binding bindingHelloDirect() {
        return BindingBuilder.bind(queueHello()).to(contractFanoutExchange());//.with("CalonDirectRouting");
    }
}
