package com.platform.springboot.wxmessage;

import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.JWT;
import com.platform.springboot.annotation.UserLoginToken;
import com.platform.springboot.domain.ResultCode;
import com.platform.springboot.domain.ResultJson;
import com.platform.springboot.domain.WebUserToken;
import com.platform.springboot.http.HttpAPIService;
import com.platform.springboot.utils.EmptyUtilHelper;
import com.platform.springboot.utils.JSONMap;
import com.platform.springboot.utils.JSONUtil;
import com.platform.springboot.utils.SpringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * @ClassName: GetWxUserinfo
 * @Description: ${description}
 * @Authror zhouy
 * @Date 2019-07-23 19:34
 */
@Slf4j
@RestController
@Api(tags = "企业微信")
public class GetWxUserinfo {

    @GetMapping("/weixin/accessToken")
    @ApiOperation(value = "获取微信token", notes = "根据基础平台appid，获取微信token")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "Authorization", value = "参数格式 token", required = true, dataType = "string", paramType = "header")})
    @UserLoginToken(required = true)
    public @ResponseBody ResultJson<JSONMap<String,Object>> accessToken(HttpServletRequest httpServletRequest){
        try{
            // 从 http 请求头中取出 token
            String token = httpServletRequest.getHeader("Authorization");
            String appid = JWT.decode(token).getAudience().get(0);
            log.info("获取token的应用====="+appid);
            Map<String,Object> map = SpringUtil.getBean(ApiConfig.class).getaccessTokenByPlatformAppid(appid);
            return ResultJson.ok(map);
        }catch(Exception e){
            e.printStackTrace();
            return ResultJson.failure(ResultCode.SERVER_ERROR);
        }
    }


    @GetMapping("/weixin/jsApiTicket")
    @ApiOperation(value = "获取微信jsApiTicket", notes = "根据基础平台appid，获取微信jsApiTicket")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "Authorization", value = "参数格式 token", required = true, dataType = "string", paramType = "header")})
    @UserLoginToken(required = true)
    public @ResponseBody ResultJson<JSONMap<String,Object>> jsApiTicket(HttpServletRequest httpServletRequest){
        try{
            // 从 http 请求头中取出 token
            String token = httpServletRequest.getHeader("Authorization");
            String appid = JWT.decode(token).getAudience().get(0);
            log.info("获取jsApiTicket的应用====="+appid);
            Map<String,Object> map = SpringUtil.getBean(ApiConfig.class).getJsApiTicketByPlatformAppid(appid);
            return ResultJson.ok(map);
        }catch(Exception e){
            e.printStackTrace();
            return ResultJson.failure(ResultCode.SERVER_ERROR);
        }
    }
}
