package com.platform.springboot.wxmessage;

import com.alibaba.fastjson.JSONObject;
import com.platform.springboot.http.HttpAPIService;
import com.platform.springboot.utils.JSONUtil;
import com.platform.springboot.utils.SpringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @ClassName: messagesend
 * @Description: ${description}  
 * @Authror zhouy
 * @Date 2019-07-22 15:58
 */

@Slf4j
@Component
public class Messagesend {

    @Value("${weixin-params.wx_sendmessage_url}")
    private String WX_SENDMESSAGE_URL;

    @Value("${weixin-params.wx_corpid}")
    private String WX_CORPID;

    @Value("$weixin-params.{wx_agentid}")
    private String WX_AGENTID;

    @Resource
    private HttpAPIService httpAPIService;

    @Async
    public JSONObject messagesend(MessageSendType messageSendType){

        String access_token = null;//SpringUtil.getBean(ApiConfig.class).getAccessToken();
        //1.获取json字符串：将message对象转换为json字符串
        String jsonstr = JSONUtil.toJson(this.getTextMessage(messageSendType));
        JSONObject httpResult = new JSONObject();
        log.info("推送消息"+jsonstr);
        try {
            String sendurl = WX_SENDMESSAGE_URL+access_token;
             httpResult= httpAPIService.doPost(sendurl,jsonstr);
            log.info("推送信息: "+httpResult.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return httpResult;
    }

    /**
     * 功能描述: <br>构建发送信息用户组
     * 〈〉
     * @Param: [list]
     * @Return: [list]
     * @Author: zhouy
     * @Date: 2019-07-24 20:45
     */

//    private String buildUserids(List<SysUserInfoEntity> list){
//        String userids ="";
//        if (list!=null&&list.size()>0){
//            for (SysUserInfoEntity sysUserInfoEntity : list){
//                userids+=sysUserInfoEntity.getPlatformUsernum();
//                if(!EmptyUtilHelper.isEmpty(sysUserInfoEntity.getPlatformUsernum())){
//                    userids=userids+"|";
//                }
//            }
//            userids = userids.substring(0,userids.length()-1);
//        }
//
//        return userids;
//    }

    /**
     * 功能描述: 构建消息体
     * 〈〉
     * @Param: []messageSendTyp
     * @Return: []
     * @Author: zhouy
     * @Date: 2019-08-02 16:47
     */
    private TextMessage getTextMessage(MessageSendType messageSendType){
        String toUserids="";
//        if(EmptyUtilHelper.isEmpty(messageSendType.getUsernum())){//处理直接传递工号推送类型消息
//            if (EmptyUtilHelper.isEmpty(messageSendType.getOrgcode())){
//                list = sysUserInfoService.getSysuserinfoBydepartmentId(messageSendType);
//            }else{
//                list = sysUserInfoService.getSysUserInfoByroleAndOrgCode(messageSendType.getRole(),messageSendType.getOrgcode());
//            }
//            toUserids =this.buildUserids(list);
//        }else{
//            toUserids = messageSendType.getUsernum();
//        }

        TextMessage message=new TextMessage();
        message.setTouser(toUserids);
        message.setMsgtype("text");
        message.setAgentid(Integer.parseInt(WX_AGENTID));
        Text text=new Text();
        text.setContent(messageSendType.getDepiction());
        message.setText(text);
        return message;
    }

}
