package com.platform.springboot;

import com.platform.springboot.wxmessage.ApiConfig;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.ConfigurableApplicationContext;

@SpringBootApplication
@EnableCaching
@MapperScan("com.platform.springboot.mapper")
public class SpringbootApplication {


    public static void main(String[] args) {
//        SpringApplication.run(SpringbootApplication.class, args);
        //初始化微信相关配置
        ConfigurableApplicationContext context =  SpringApplication.run(SpringbootApplication.class, args);
        context.getBean(ApiConfig.class).ApiConfigInit(true);
    }
}
