package com.platform.springboot.api;

/**
 * .::::.
 * .::::::::.
 * :::::::::::    佛主保佑、永无Bug
 * ..:::::::::::'
 * '::::::::::::'
 * .::::::::::
 * '::::::::::::::..
 * ..::::::::::::.
 * ``::::::::::::::::
 * ::::``:::::::::'        .:::.
 * ::::'   ':::::'       .::::::::.
 * .::::'      ::::     .:::::::'::::.
 * .:::'       :::::  .:::::::::' ':::::.
 * .::'        :::::.:::::::::'      ':::::.
 * .::'         ::::::::::::::'         ``::::.
 * ...:::           ::::::::::::'              ``::.
 * ```` ':.          ':::::::::'                  ::::..
 * '.:::::'                    ':'````..
 */

import com.platform.springboot.annotation.UserLoginToken;
import com.platform.springboot.domain.ResponseUserToken;
import com.platform.springboot.domain.ResultCode;
import com.platform.springboot.domain.ResultJson;
import com.platform.springboot.domain.entity.Applications;
import com.platform.springboot.domain.entity.User;
import com.platform.springboot.rabbitmq.AmqpService;
import com.platform.springboot.service.ApplicationsService;
import com.platform.springboot.service.TokenService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

/**
 * @ClassName: ApplicationsApi
 * @Description: ${description}  
 * @Authror zhouy
 * @Date 2019-08-27 17:48
 */
@Slf4j
@RestController
@Api(tags = "token调用接口类")
public class ApplicationsApi {

    @Autowired
    ApplicationsService applicationsService;
    @Autowired
    TokenService tokenService;
    @Autowired
    AmqpService amqpService;

    @PostMapping(value = "/applicationsToken")
    @ApiOperation(value = "获得token", notes = "调用成功返回token")
    public ResultJson applicationsToken(
            @Valid @RequestBody User user){
        String token = "";
        Applications application = applicationsService.getApplications(user.getAppid(),user.getSecret());
        if (application!=null){
            token =tokenService.getToken(application);
        }else{
            return ResultJson.failure(ResultCode.UNAUTHORIZED);
        }
        log.info("应用验证成功，appid："+user.getAppid());
        return ResultJson.ok(token);
    }

    @UserLoginToken
    @GetMapping("/getMessage")
    public String getMessage(){
        return "你已通过验证";
    }
}
