package com.platform.springboot.domain.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel(description= "具体参数描述")
@JsonInclude(value= JsonInclude.Include.NON_NULL)
public class PersonneBaseDTO implements Serializable {


    @ApiModelProperty(value = "部门或员工id")
    private Integer id;
    @ApiModelProperty(value = "部门或员工名")
    private String title;
    @ApiModelProperty(value = "上级id")
    private String pid;
    @ApiModelProperty(value = "部门或员工名")
    private String label;
    @ApiModelProperty(value = "部门或员工id")
    private Integer key;
    @ApiModelProperty(value = "工号")
    private String no;
    @ApiModelProperty(value = "头像")
    private String avatar;


    public PersonneBaseDTO(PersonneDTO dto){
        this.pid= dto.getPid();
        this.id=dto.getId();
        this.title=dto.getTitle();
        this.label=dto.getLabel();
        this.key=dto.getKey();
        this.no= dto.getNo();
        this.avatar = dto.getAvatar();
    }

}
