package com.platform.springboot.service;

import com.github.pagehelper.PageInfo;
import com.platform.springboot.domain.ResultJson;
import com.platform.springboot.domain.dto.*;
import com.platform.springboot.domain.entity.Personnel;
import org.springframework.cache.annotation.Cacheable;

import java.util.List;
import java.util.Map;

public interface PersonnelService {

    /**
     * 获得所有部门人员： http://ditie.wbb.aizhuanxing.com/index/jiekou/view_deptall/
     *对应的清除缓存标签  @CacheEvict 在auth工程中的修改人员或部门的方法上
     * @return
     */
    @Cacheable(value = "viewDeptall",key = "'tree'")
    DepartmentPersonneDTO getDepartmentPersonneDTO();

    DepartmentPersonneDTO getDepartmentPersonneDTOBranch(String branchCompanyId);

    /**
     * 获取全部部门以及部门下的人员http://ditie.wbb.aizhuanxing.com/index/jiekou/dept_all
     *
     * @return
     */
    DepartmentPersonneDTO getDepartmentPersonneDTO2(String dept);


    /**
     * 根据部门id查询用户信息：http://ditie.wbb.aizhuanxing.com/index/jiekou/personnel?dept=
     */
    ResultJson getDepartmentPersonneBydept(String dept, String type);

    /**
     * 根据工号查询员工信息：http://ditie.wbb.aizhuanxing.com/index/jiekou/account_sel?account=1128
     */
    Personnel getPersonByAccount(String account);

    /**
     * 根据工号获取用户信息，多个用逗号分隔
     * @param account
     * @return
     */
    List<PersonneDTO> getPersonListByAccount(String account);

    /**
     * 根据部门ID查询： http://ditie.wbb.aizhuanxing.com/index/jiekou/dept_user?id=8
     */
    List<Personnel> getPersonBydept(String dept);

    /**
     * 查询所有员工接口 http://ditie.wbb.aizhuanxing.com/index/jiekou/users?page=1&limit=8000&state=1
     */

    PageInfo<PersonnelPageDTO> selectPersonPage(Integer pageNum, Integer pageSize, String status);

    /**
     * 根据部门id查询员工及其子部门下的员工
     *
     * @param dept
     * @return
     */
    List<Personnel> getAllPersonBydept(String dept, String type);
    List<Personnel> getAllPersonBydeptMatte(String dept, String type);

    List<PersonnelPageDTO> deptAllUser();

    List<PersonnelPageDTO> allUser(boolean excludeDel);

    /**
     * 根据id查询用户信息：http://ditie.aizhuanxing.com/index/jiekou/users_one
     */
    ResultJson getDepartmentPersonneByid(String id, String type);

    /**
     * 根据用户ID，获取用户下的部门ID
     * @param id
     * @return
     */
    ResultJson getChildrenDepartmentByuserId(String id);

    /**
     * 获取当前人员上级(普通员工获取部门领导，部门领导获取上级部门领导)
     * 接口地址http://ditie.wbb.aizhuanxing.com/index/jiekou/lead
     */
    List<Personnel> getPersonLead(String id);


    /**
     * 获取当前人员全部上级部门
     * 接口地址http://ditie.wbb.aizhuanxing.com/index/jiekou/level_dept
     * 参数 	uid		用户id
     */
    List<String> getLeveldept(String id);

    /**
     * 通过部门id查询所有下级
     * 接口地址http://ditie.wbb.aizhuanxing.com/index/jiekou/user_down
     * 参数	dept_id	部门id
     */


    /**
     * 返回当前人员的部门领导
     * 接口地址http://ditie.wbb.aizhuanxing.com/index/jiekou/dept_lingdao
     * 参数		uid	用户id
     */
    List<Personnel> getDeptLead(String id);

    /**
     * 查询分管领导
     * 接口地址http://ditie.wbb.aizhuanxing.com/index/jiekou/dept_fen
     * 参数		uid	用户id
     */
    List<Personnel> getDeptFen(String id);

    /**
     * 通过姓名和工号搜索
     * 接口地址http://ditie.wbb.aizhuanxing.com/index/jiekou/search
     * 参数	key		姓名或者工号
     * paizhu		派驻单位id
     * state			字段限制，为1不限制
     * page				页数
     */
    PageInfo<PersonnelPageDTO> selectPersonPageSearch(SearchDTO DTO);

    /**
     * 部门树不含员工
     * @param
     * @return
     */
    DepartmentPersonneDTO getDepartmentTree();

    /**
     * 根据工号获取用户信息(详细信息)，多个用逗号分隔
     * @param account
     * @return
     */

    List<PersonnelPageDTO> getPersonnelPageByAccount(String account);

    /**
     * 查询指定日期或当日人员变更记录
     * @param updatetime
     * @return
     */

    List<PersonnewxDTO> getpersonnellistbyday(String updatetime);


    Map getCompanyIdByUserId(String userId);
}