package com.platform.springboot.utils;

/**
 * .::::.
 * .::::::::.
 * :::::::::::    佛主保佑、永无Bug
 * ..:::::::::::'
 * '::::::::::::'
 * .::::::::::
 * '::::::::::::::..
 * ..::::::::::::.
 * ``::::::::::::::::
 * ::::``:::::::::'        .:::.
 * ::::'   ':::::'       .::::::::.
 * .::::'      ::::     .:::::::'::::.
 * .:::'       :::::  .:::::::::' ':::::.
 * .::'        :::::.:::::::::'      ':::::.
 * .::'         ::::::::::::::'         ``::::.
 * ...:::           ::::::::::::'              ``::.
 * ```` ':.          ':::::::::'                  ::::..
 * '.:::::'                    ':'````..
 */

/**
 * @ClassName: StrUtil
 * @Description: ${description}  
 * @Authror zhouy
 * @Date 2019-07-23 16:36
 */
public class StrUtil {

    /**
     * 此类不需要实例化
     */
    private StrUtil() {
    }

    /**
     * 判断一个字符串是否为空，null也会返回true
     *
     * @param str 需要判断的字符串
     * @return 是否为空，null也会返回true
     */
    public static boolean isBlank(String str) {
        return null == str || "".equals(str.trim());
    }

    /**
     * 判断一个字符串是否不为空
     *
     * @param str 需要判断的字符串
     * @return 是否为空
     */
    public static boolean isNotBlank(String str) {
        return !isBlank(str);
    }

    /**
     * 判断一组字符串是否有空值
     *
     * @param strs 需要判断的一组字符串
     * @return 判断结果，只要其中一个字符串为null或者为空，就返回true
     */
    public static boolean hasBlank(String... strs) {
        if (null == strs || 0 == strs.length) {
            return true;
        } else {
            //这种代码如果用java8就会很优雅了
            for (String str : strs) {
                if (isBlank(str)) {
                    return true;
                }
            }
        }
        return false;
    }
    /**
     * 功能描述: <br>去掉字符串最后一位字符
     * 〈〉
     * @Param: [str]
     * @Return: [str]
     * @Author: zhouy
     * @Date: 2019-11-18 23:12
     */

    public static String Rtrim(String str){
        return  str.substring(0,str.length()-1);
    }

    /**
     * 判断str1被逗号分割后是否包含str
     * @param str1
     * @param str2
     * @return
     */
    public static boolean contains(String str1 ,String str2){
        String ma = ",";
        if(!str1.contains(ma)){
            return str1.equals(str2);
        }
        String[] arr = str1.split(",");
        for (int i = 0; i < arr.length; i++) {
            if(arr[i].equals(str2)){
                return true;
            }
        }
        return false;
    }
}
