package com.platform.springboot.wxmessage;

import com.platform.springboot.redis.RedisUtils;
import com.platform.springboot.utils.JSONUtil;
import com.platform.springboot.utils.StrUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * @author
 * @ClassName: ApiConfig
 * @Description: ${description}  
 * @Authror zhouy
 * @Date 2019-07-23 13:29
 */
@Slf4j
@Component
public class ApiConfig {
    /**
     *企业微信id
     */
    @Value("${weixin-params.wx_corpid}")
    private String WX_CORPID;
    /**
     *微信token获取url
     */
    @Value("${weixin-params.wx_token_url}")
    private String WX_TOKEN_URL;
    /**
     *企业微信jssdk获取url
     */
    @Value("${weixin-params.wx_jstiket_url}")
    private String WX_JSTIKET_URL;
    /**
     *企业微信应用密钥-会议
     */
    @Value("${weixin-params.wx_secret_meeting}")
    private String WX_SECRET_MEETING;
    /**
     *企业微信应用密钥-日报
     */
    @Value("${weixin-params.wx_secret_daily}")
    private String WX_SECRET_DAILY;
    /**
     *企业微信应用密钥-审批
     */
    @Value("${weixin-params.wx_secret_approve}")
    private String WX_SECRET_APPROVE;
    /**
     *企业微信应用密钥-公告
     */
    @Value("${weixin-params.wx_secret_notice}")
    private String WX_SECRET_NOTICE;
    /**
     *企业微信应用密钥-法规
     */
    @Value("${weixin-params.wx_secret_law}")
    private String WX_SECRET_LAW;
    /**
     *企业微信应用密钥-考勤
     */
    @Value("${weixin-params.wx_secret_matte}")
    private String WX_SECRET_MATTE;

    /**
     *
     */
    @Autowired
    private RedisUtils redisUtils;

    /**
     *基础平台会议应用appid
     */
    @Value("${weixin-params.platform_appid_meeting}")
    private  String PLATFORM_APPID_MEETING;
    /**
     *基础平台日报应用appid
     */
    @Value("${weixin-params.platform_appid_daily}")
    private  String PLATFORM_APPID_DAILY;
    /**
     *基础平台审批应用appid
     */
    @Value("${weixin-params.platform_appid_approve}")
    private String PLATFORM_APPID_APPROVE;
    /**
     *基础平台公告应用appid
     */
    @Value("${weixin-params.platform_appid_notice}")
    private String PLATFORM_APPID_NOTICE;
    /**
     *基础平台法规应用appid
     */
    @Value("${weixin-params.platform_appid_law}")
    private String PLATFORM_APPID_LAW;
    /**
     *基础平台考勤应用appid
     */
    @Value("${weixin-params.platform_appid_matte}")
    private String PLATFORM_APPID_MATTE;

    /**
     *redis缓存时长
     */
    private long cacheLongTime = 7100L;
    /**
     *缓存的accessToken后缀
     */
    private String accessToken = "accessToken";
    /**
     *缓存的jssdk后缀
     */
    private String ticket = "ticket";

    /**
     *是否启用jssdk
     */
    private boolean enableJsApi;

    /**
     * 会议
     */
    private final AtomicBoolean Refreshing_meeting   = new AtomicBoolean(false);
    private final AtomicBoolean jsRefreshing_meeting   = new AtomicBoolean(false);
    private       String  accessToken_meeting;
    private       long    weixinTokenStartTime_meeting;
    private       String  jsApiTicket_meeting;
    private       long    jsTokenStartTime_meeting;

    /**
     *日报
     */
    private final AtomicBoolean Refreshing_daily  = new AtomicBoolean(false);
    private final AtomicBoolean jsRefreshing_daily  = new AtomicBoolean(false);
    private       String  accessToken_daily;
    private       long    weixinTokenStartTime_daily;
    private       String  jsApiTicket_daily;
    private       long    jsTokenStartTime_daily;

    /**
     *审批
     */
    private final AtomicBoolean Refreshing_approve   = new AtomicBoolean(false);
    private final AtomicBoolean jsRefreshing_approve   = new AtomicBoolean(false);
    private       String  accessToken_approve;
    private       long    weixinTokenStartTime_approve;
    private       String  jsApiTicket_approve;
    private       long    jsTokenStartTime_approve;
    /**
     *公告
     */
    private final AtomicBoolean Refreshing_notice   = new AtomicBoolean(false);
    private final AtomicBoolean jsRefreshing_notice   = new AtomicBoolean(false);
    private       String  accessToken_notice;
    private       long    weixinTokenStartTime_notice;
    private       String  jsApiTicket_notice;
    private       long    jsTokenStartTime_notice;
    /**
     *法规
     */
    private final AtomicBoolean Refreshing_law   = new AtomicBoolean(false);
    private final AtomicBoolean jsRefreshing_law   = new AtomicBoolean(false);
    private       String  accessToken_law;
    private       long    weixinTokenStartTime_law;
    private       String  jsApiTicket_law;
    private       long    jsTokenStartTime_law;
    /**
     *考勤
     */
    private final AtomicBoolean Refreshing_matte   = new AtomicBoolean(false);
    private final AtomicBoolean jsRefreshing_matte   = new AtomicBoolean(false);
    private       String  accessToken_matte;
    private       long    weixinTokenStartTime_matte;
    private       String  jsApiTicket_matte;
    private       long    jsTokenStartTime_matte;

    public void  ApiConfigInit(boolean enableJsApi) {//实体初始化方法
        this.enableJsApi = enableJsApi;
        long now = System.currentTimeMillis();

        log.info("meeting----开始获取微信token...");
        log.info("meeting----Token获取完成,当前token ["+getaccessToken_meeting()+"]...");
        log.info("meeting----jsApiTicket获取完成,当前jsApiTicket ["+getJsApiTicket_meeting()+"]...");

        log.info("daily----开始获取微信token...");
        log.info("daily----Token获取完成,当前token ["+getaccessToken_daily()+"]...");
        log.info("daily----jsApiTicket获取完成,当前jsApiTicket ["+getJsApiTicket_daily()+"]...");

        log.info("approve----开始获取微信token...");
        log.info("approve----Token获取完成,当前token ["+getaccessToken_approve()+"]...");
        log.info("approve----jsApiTicket获取完成,当前jsApiTicket ["+getJsApiTicket_approve()+"]...");

        log.info("notice----开始获取微信token...");
        log.info("notice----Token获取完成,当前token ["+getaccessToken_notice()+"]...");
        log.info("notice----jsApiTicket获取完成,当前jsApiTicket ["+getJsApiTicket_notice()+"]...");

        log.info("law----开始获取微信token...");
        log.info("law----Token获取完成,当前token ["+getaccessToken_law()+"]...");
        log.info("law----jsApiTicket获取完成,当前jsApiTicket ["+getJsApiTicket_law()+"]...");

        log.info("matte----开始获取微信token...");
        log.info("matte----Token获取完成,当前token ["+getaccessToken_matte()+"]...");
        log.info("matte----jsApiTicket获取完成,当前jsApiTicket ["+getJsApiTicket_matte()+"]...");


    }


    //========================================================会议部分开始============================================
    public String getaccessToken_meeting() {
        long now = System.currentTimeMillis();
        String key = PLATFORM_APPID_MEETING+accessToken;
        boolean hasKey = redisUtils.exists(key);
        //缓存过期证明当前的accestoken已经过期刷新一下
        if(!hasKey){
            initToken_meeting(now);
            //数据插入缓存（set中的参数含义：key值，user对象，缓存存在时间10（long类型），时间单位）
            redisUtils.set(key,accessToken_meeting,cacheLongTime, TimeUnit.SECONDS);
        }else{
            Object object =  redisUtils.get(key);
            accessToken_meeting = object.toString();
        }
        return accessToken_meeting;
    }

    public String getJsApiTicket_meeting() {
        if (enableJsApi) {
            long now = System.currentTimeMillis();
            //获取缓存
            String key = PLATFORM_APPID_MEETING+ticket;
            boolean hasKey = redisUtils.exists(key);
            //缓存过期证明当前的已经过期刷新一下
            if(!hasKey){
                getaccessToken_meeting();
                initJSToken_meeting(now);
                //数据插入缓存（set中的参数含义：key值，user对象，缓存存在时间10（long类型），时间单位）
                redisUtils.set(key,jsApiTicket_meeting,cacheLongTime, TimeUnit.SECONDS);
            }else{
                jsApiTicket_meeting = redisUtils.get(key).toString();
            }
        } else {
            jsApiTicket_meeting = null;
        }
        return jsApiTicket_meeting;
    }

    /**
     * 功能描述: <br> 获取token
     */
    private void initToken_meeting(final long refreshTime) {
        log.debug("开始初始化access_token........");
        //记住原本的时间，用于出错回滚
        final long oldTime = this.weixinTokenStartTime_meeting;
        this.weixinTokenStartTime_meeting = refreshTime;
        String url = WX_TOKEN_URL +"?corpid="+WX_CORPID + "&corpsecret=" + WX_SECRET_MEETING;

        NetWorkCenter.get(url, null, new NetWorkCenter.ResponseCallback() {
            @Override
            public void onResponse(int resultCode, String resultJson) {
                if (HttpStatus.SC_OK == resultCode) {
                    GetTokenResponse response = JSONUtil.toBean(resultJson, GetTokenResponse.class);
                    log.debug("获取access_token:{}", response.getAccessToken());
                    if (null == response.getAccessToken()) {
                        //刷新时间回滚
                        weixinTokenStartTime_meeting = oldTime;
                        if(!Refreshing_meeting.getAndSet(true)){
                            initToken_meeting(weixinTokenStartTime_meeting);
                        }
                        log.error("微信公众号token获取出错，错误信息:" + response.getErrcode() + "," + response.getErrmsg());
                    }else {
                        accessToken_meeting = response.getAccessToken();
                        Refreshing_meeting.set(false);
                    }
                }
            }
        });

    }
    /**
     * 功能描述: <br>初始化微信JS-SDK，获取JS-SDK token
     */
    private void initJSToken_meeting(final long refreshTime) {
        log.debug("初始化 jsapi_ticket........");
        //记住原本的时间，用于出错回滚
        final long oldTime = this.jsTokenStartTime_meeting;
        this.jsTokenStartTime_meeting = refreshTime;
        String url = WX_JSTIKET_URL + accessToken_meeting;
        NetWorkCenter.get(url, null, new NetWorkCenter.ResponseCallback() {
            @Override
            public void onResponse(int resultCode, String resultJson) {
                if (HttpStatus.SC_OK == resultCode) {
                    GetJsApiTicketResponse response = JSONUtil.toBean(resultJson, GetJsApiTicketResponse.class);
                    log.debug("获取jsapi_ticket:{}", response.getTicket());
                    if (StrUtil.isBlank(response.getTicket())) {
                        //刷新时间回滚
                        jsTokenStartTime_meeting = oldTime;
                        log.error("微信公众号jsToken获取出错，错误信息:" + response.getErrcode() + "," + response.getErrmsg());
                    }else {
                        jsApiTicket_meeting = response.getTicket();
                    }
                }
            }
        });
    }
    //========================================================会议部分结束============================================

    //========================================================日报部分开始============================================
    public String getaccessToken_daily() {
        long now = System.currentTimeMillis();
        String key = PLATFORM_APPID_DAILY+accessToken;
        boolean hasKey = redisUtils.exists(key);
        //缓存过期证明当前的accestoken已经过期刷新一下
        if(!hasKey){
            initToken_daily(now);
            //数据插入缓存（set中的参数含义：key值，user对象，缓存存在时间10（long类型），时间单位）
            redisUtils.set(key,accessToken_daily,cacheLongTime, TimeUnit.SECONDS);

        }else{
            Object object =  redisUtils.get(key);
            accessToken_daily = object.toString();
        }
        return accessToken_daily;
    }

    public String getJsApiTicket_daily() {
        if (enableJsApi) {
            long now = System.currentTimeMillis();
            try {
                //获取缓存
                String key = PLATFORM_APPID_DAILY+ticket;
                boolean hasKey = redisUtils.exists(key);
                //缓存过期证明当前的accestoken已经过期刷新一下
                if(!hasKey){
                    getaccessToken_daily();
                    initJSToken_daily(now);
                    //数据插入缓存（set中的参数含义：key值，user对象，缓存存在时间10（long类型），时间单位）
                    redisUtils.set(key,jsApiTicket_meeting,cacheLongTime, TimeUnit.SECONDS);
                }else {
                    jsApiTicket_daily = redisUtils.get(key).toString();
                }
            } finally {
                jsRefreshing_daily.set(false);
            }
        } else {
            jsApiTicket_daily = null;
        }
        return jsApiTicket_daily;
    }

    /**
     * 功能描述: <br> 获取token
     */
    private void initToken_daily(final long refreshTime) {
        log.debug("开始初始化access_token........");
        //记住原本的时间，用于出错回滚
        final long oldTime = this.weixinTokenStartTime_daily;
        this.weixinTokenStartTime_daily = refreshTime;
        String url = WX_TOKEN_URL +"?corpid="+WX_CORPID + "&corpsecret=" + WX_SECRET_DAILY;

        NetWorkCenter.get(url, null, new NetWorkCenter.ResponseCallback() {
            @Override
            public void onResponse(int resultCode, String resultJson) {
                if (HttpStatus.SC_OK == resultCode) {
                    GetTokenResponse response = JSONUtil.toBean(resultJson, GetTokenResponse.class);
                    log.debug("获取access_token:{}", response.getAccessToken());
                    if (null == response.getAccessToken()) {
                        //刷新时间回滚
                        weixinTokenStartTime_daily = oldTime;
                        if(!Refreshing_daily.getAndSet(true)){
                            initToken_daily(weixinTokenStartTime_daily);
                        }
                        log.error("微信公众号token获取出错，错误信息:" + response.getErrcode() + "," + response.getErrmsg());
                    }else {
                        accessToken_daily = response.getAccessToken();
                        Refreshing_daily.set(false);
                    }
                }
            }
        });

    }
    /**
     * 功能描述: <br>初始化微信JS-SDK，获取JS-SDK token
     */
    private void initJSToken_daily(final long refreshTime) {
        log.debug("初始化 jsapi_ticket........");
        //记住原本的时间，用于出错回滚
        final long oldTime = this.jsTokenStartTime_daily;
        this.jsTokenStartTime_daily = refreshTime;
        String url = WX_JSTIKET_URL + accessToken_daily;
        NetWorkCenter.get(url, null, new NetWorkCenter.ResponseCallback() {
            @Override
            public void onResponse(int resultCode, String resultJson) {
                if (HttpStatus.SC_OK == resultCode) {
                    GetJsApiTicketResponse response = JSONUtil.toBean(resultJson, GetJsApiTicketResponse.class);
                    log.debug("获取jsapi_ticket:{}", response.getTicket());
                    if (StrUtil.isBlank(response.getTicket())) {
                        //刷新时间回滚
                        jsTokenStartTime_daily = oldTime;
                        log.error("微信公众号jsToken获取出错，错误信息:" + response.getErrcode() + "," + response.getErrmsg());
                    }else {
                        jsApiTicket_daily = response.getTicket();
                    }
                }
            }
        });
    }
    //========================================================日报部分结束============================================

    //========================================================审批部分开始============================================
    public String getaccessToken_approve() {
        long now = System.currentTimeMillis();
        String key = PLATFORM_APPID_APPROVE+accessToken;
        boolean hasKey = redisUtils.exists(key);
        Object object =  redisUtils.get(key);
        if(!hasKey || null==object){
            initToken_approve(now);
            //数据插入缓存（set中的参数含义：key值，user对象，缓存存在时间10（long类型），时间单位）
            redisUtils.set(key,accessToken_approve,cacheLongTime, TimeUnit.SECONDS);
        }else{
            accessToken_approve = object.toString();
            log.info("从缓存中获取accessToken_approve=["+accessToken_approve+"]");

        }
        return accessToken_approve;
    }

    public String getJsApiTicket_approve() {
        if (enableJsApi) {
            long now = System.currentTimeMillis();
            try {
                //获取缓存
                String key = PLATFORM_APPID_APPROVE+ticket;
                boolean hasKey = redisUtils.exists(key);
                //缓存过期证明当前的accestoken已经过期刷新一下
                if(!hasKey){
                    getaccessToken_approve();
                    initJSToken_approve(now);
                    //数据插入缓存（set中的参数含义：key值，user对象，缓存存在时间10（long类型），时间单位）
                    redisUtils.set(key,jsApiTicket_approve,cacheLongTime, TimeUnit.SECONDS);
                }else {
                    jsApiTicket_approve =  redisUtils.get(key).toString();
                }
            } finally {
                jsRefreshing_approve.set(false);
            }
        } else {
            jsApiTicket_approve = null;
        }
        return jsApiTicket_approve;
    }

    /**
     * 功能描述: <br> 获取token
     */
    private void initToken_approve(final long refreshTime) {
        log.debug("开始初始化access_token........");
        //记住原本的时间，用于出错回滚
        final long oldTime = this.weixinTokenStartTime_approve;
        this.weixinTokenStartTime_approve = refreshTime;
        String url = WX_TOKEN_URL +"?corpid="+WX_CORPID + "&corpsecret=" + WX_SECRET_APPROVE;

        NetWorkCenter.get(url, null, new NetWorkCenter.ResponseCallback() {
            @Override
            public void onResponse(int resultCode, String resultJson) {
                if (HttpStatus.SC_OK == resultCode) {
                    GetTokenResponse response = JSONUtil.toBean(resultJson, GetTokenResponse.class);
                    log.debug("获取access_token:{}", response.getAccessToken());
                    if (null == response.getAccessToken()) {
                        //刷新时间回滚
                        weixinTokenStartTime_approve = oldTime;
                        if(!Refreshing_approve.getAndSet(true)){
                            initToken_approve(weixinTokenStartTime_approve);
                        }
                        log.error("微信公众号token获取出错，错误信息:" + response.getErrcode() + "," + response.getErrmsg());
                    }else {
                        accessToken_approve = response.getAccessToken();
                        Refreshing_approve.set(false);
                    }
                }
            }
        });

    }
    /**
     * 功能描述: <br>初始化微信JS-SDK，获取JS-SDK token
     */
    private void initJSToken_approve(final long refreshTime) {
        log.debug("初始化 jsapi_ticket........");
        //记住原本的时间，用于出错回滚
        final long oldTime = this.jsTokenStartTime_approve;
        this.jsTokenStartTime_approve = refreshTime;
        String url = WX_JSTIKET_URL + accessToken_approve;
        NetWorkCenter.get(url, null, new NetWorkCenter.ResponseCallback() {
            @Override
            public void onResponse(int resultCode, String resultJson) {
                if (HttpStatus.SC_OK == resultCode) {
                    GetJsApiTicketResponse response = JSONUtil.toBean(resultJson, GetJsApiTicketResponse.class);
                    log.debug("获取jsapi_ticket:{}", response.getTicket());
                    if (StrUtil.isBlank(response.getTicket())) {
                        //刷新时间回滚
                        jsTokenStartTime_approve = oldTime;
                        log.error("微信公众号jsToken获取出错，错误信息:" + response.getErrcode() + "," + response.getErrmsg());
                    }else {
                        jsApiTicket_approve = response.getTicket();
                    }
                }
            }
        });
    }
    //========================================================审批部分结束============================================

    //========================================================公告部分开始============================================
    public String getaccessToken_notice() {
        long now = System.currentTimeMillis();
        String key = PLATFORM_APPID_NOTICE+accessToken;
        boolean hasKey = redisUtils.exists(key);
        if (!hasKey){
            initToken_notice(now);
            //数据插入缓存（set中的参数含义：key值，user对象，缓存存在时间10（long类型），时间单位）
            redisUtils.set(key,accessToken_notice,cacheLongTime, TimeUnit.SECONDS);
        }else{
            Object object =  redisUtils.get(key);
            accessToken_notice = object.toString();
        }
        return accessToken_notice;
    }

    public String getJsApiTicket_notice() {
        if (enableJsApi) {
            long now = System.currentTimeMillis();
            try {
                //获取缓存
                String key = PLATFORM_APPID_NOTICE+ticket;
                boolean hasKey = redisUtils.exists(key);
                //缓存过期证明当前的accestoken已经过期刷新一下
                if(!hasKey){
                    getaccessToken_notice();
                    initJSToken_notice(now);
                    //数据插入缓存（set中的参数含义：key值，user对象，缓存存在时间10（long类型），时间单位）
                    redisUtils.set(key,jsApiTicket_notice,cacheLongTime, TimeUnit.SECONDS);
                }else {
                    jsApiTicket_notice = redisUtils.get(key).toString();
                }
            } finally {
                jsRefreshing_notice.set(false);
            }
        } else {
            jsApiTicket_notice = null;
        }
        return jsApiTicket_notice;
    }

    /**
     * 功能描述: <br> 获取token
     */
    private void initToken_notice(final long refreshTime) {
        log.debug("开始初始化access_token........");
        //记住原本的时间，用于出错回滚
        final long oldTime = this.weixinTokenStartTime_notice;
        this.weixinTokenStartTime_notice = refreshTime;
        String url = WX_TOKEN_URL +"?corpid="+WX_CORPID + "&corpsecret=" + WX_SECRET_NOTICE;

        NetWorkCenter.get(url, null, new NetWorkCenter.ResponseCallback() {
            @Override
            public void onResponse(int resultCode, String resultJson) {
                if (HttpStatus.SC_OK == resultCode) {
                    GetTokenResponse response = JSONUtil.toBean(resultJson, GetTokenResponse.class);
                    log.debug("获取access_token:{}", response.getAccessToken());
                    if (null == response.getAccessToken()) {
                        //刷新时间回滚
                        weixinTokenStartTime_notice = oldTime;
                        if(!Refreshing_notice.getAndSet(true)){
                            initToken_notice(weixinTokenStartTime_notice);
                        }
                        log.error("微信公众号token获取出错，错误信息:" + response.getErrcode() + "," + response.getErrmsg());
                    }else{
                        accessToken_notice = response.getAccessToken();
                        Refreshing_notice.set(false);
                    }
                }
            }
        });

    }
    /**
     * 功能描述: <br>初始化微信JS-SDK，获取JS-SDK token
     */
    private void initJSToken_notice(final long refreshTime) {
        log.debug("初始化 jsapi_ticket........");
        //记住原本的时间，用于出错回滚
        final long oldTime = this.jsTokenStartTime_notice;
        this.jsTokenStartTime_notice = refreshTime;
        String url = WX_JSTIKET_URL + accessToken_notice;
        NetWorkCenter.get(url, null, new NetWorkCenter.ResponseCallback() {
            @Override
            public void onResponse(int resultCode, String resultJson) {
                if (HttpStatus.SC_OK == resultCode) {
                    GetJsApiTicketResponse response = JSONUtil.toBean(resultJson, GetJsApiTicketResponse.class);
                    log.debug("获取jsapi_ticket:{}", response.getTicket());
                    if (StrUtil.isBlank(response.getTicket())) {
                        //刷新时间回滚
                        jsTokenStartTime_notice = oldTime;
                        log.error("微信公众号jsToken获取出错，错误信息:" + response.getErrcode() + "," + response.getErrmsg());
                    }else {
                        jsApiTicket_notice = response.getTicket();
                    }
                }
            }
        });
    }
    //========================================================公告部分结束============================================

    //========================================================法规部分开始============================================
    public String getaccessToken_law() {
        long now = System.currentTimeMillis();
        String key = PLATFORM_APPID_LAW+accessToken;
        boolean hasKey = redisUtils.exists(key);
        if (!hasKey){
            initToken_law(now);
            //数据插入缓存（set中的参数含义：key值，user对象，缓存存在时间10（long类型），时间单位）
            redisUtils.set(key,accessToken_law,cacheLongTime, TimeUnit.SECONDS);
        }else{
            Object object =  redisUtils.get(key);
            accessToken_law = object.toString();
        }
        return accessToken_law;
    }

    public String getJsApiTicket_law() {
        if (enableJsApi) {
            long now = System.currentTimeMillis();
            try {
                //获取缓存
                String key = PLATFORM_APPID_LAW+ticket;
                boolean hasKey = redisUtils.exists(key);
                //缓存过期证明当前的accestoken已经过期刷新一下
                if(!hasKey){
                    getaccessToken_law();
                    initJSToken_law(now);
                    //数据插入缓存（set中的参数含义：key值，user对象，缓存存在时间10（long类型），时间单位）
                    redisUtils.set(key,jsApiTicket_law,cacheLongTime, TimeUnit.SECONDS);
                }else {
                    jsApiTicket_law =  redisUtils.get(key).toString();
                }
            } finally {
                jsRefreshing_law.set(false);
            }
        } else {
            jsApiTicket_law = null;
        }
        return jsApiTicket_law;
    }

    /**
     * 功能描述: <br> 获取token
     */
    private void initToken_law(final long refreshTime) {
        log.debug("开始初始化access_token........");
        //记住原本的时间，用于出错回滚
        final long oldTime = this.weixinTokenStartTime_law;
        this.weixinTokenStartTime_law = refreshTime;
        String url = WX_TOKEN_URL +"?corpid="+WX_CORPID + "&corpsecret=" + WX_SECRET_LAW;

        NetWorkCenter.get(url, null, new NetWorkCenter.ResponseCallback() {
            @Override
            public void onResponse(int resultCode, String resultJson) {
                if (HttpStatus.SC_OK == resultCode) {
                    GetTokenResponse response = JSONUtil.toBean(resultJson, GetTokenResponse.class);
                    log.debug("获取access_token:{}", response.getAccessToken());
                    if (null == response.getAccessToken()) {
                        //刷新时间回滚
                        weixinTokenStartTime_law = oldTime;
                        if(!Refreshing_law.getAndSet(true)){
                            initToken_law(weixinTokenStartTime_law);
                        }
                        log.error("微信公众号token获取出错，错误信息:" + response.getErrcode() + "," + response.getErrmsg());
                    }else{
                        accessToken_law = response.getAccessToken();
                        Refreshing_law.set(false);
                    }
                }
            }
        });

    }
    /**
     * 功能描述: <br>初始化微信JS-SDK，获取JS-SDK token
     */
    private void initJSToken_law(final long refreshTime) {
        log.debug("初始化 jsapi_ticket........");
        //记住原本的时间，用于出错回滚
        final long oldTime = this.jsTokenStartTime_law;
        this.jsTokenStartTime_law = refreshTime;
        String url = WX_JSTIKET_URL + accessToken_law;
        NetWorkCenter.get(url, null, new NetWorkCenter.ResponseCallback() {
            @Override
            public void onResponse(int resultCode, String resultJson) {
                if (HttpStatus.SC_OK == resultCode) {
                    GetJsApiTicketResponse response = JSONUtil.toBean(resultJson, GetJsApiTicketResponse.class);
                    log.debug("获取jsapi_ticket:{}", response.getTicket());
                    if (StrUtil.isBlank(response.getTicket())) {
                        //刷新时间回滚
                        jsTokenStartTime_law = oldTime;
                        log.error("微信公众号jsToken获取出错，错误信息:" + response.getErrcode() + "," + response.getErrmsg());
                    }else {
                        jsApiTicket_law = response.getTicket();
                    }
                }
            }
        });
    }
    //========================================================法规部分结束============================================


    //========================================================考勤部分开始============================================
    public String getaccessToken_matte() {
        long now = System.currentTimeMillis();
        String key = PLATFORM_APPID_MATTE+accessToken;
        boolean hasKey = redisUtils.exists(key);
        if (!hasKey){
            initToken_matte(now);
            //数据插入缓存（set中的参数含义：key值，user对象，缓存存在时间10（long类型），时间单位）
            redisUtils.set(key,accessToken_matte,cacheLongTime, TimeUnit.SECONDS);
        }else{
            Object object =  redisUtils.get(key);
            accessToken_matte = object.toString();
        }
        return accessToken_matte;
    }

    public String getJsApiTicket_matte() {
        if (enableJsApi) {
            long now = System.currentTimeMillis();
            try {
                //获取缓存
                String key = PLATFORM_APPID_MATTE+ticket;
                boolean hasKey = redisUtils.exists(key);
                //缓存过期证明当前的accestoken已经过期刷新一下
                if(!hasKey){
                    getaccessToken_matte();
                    initJSToken_matte(now);
                    //数据插入缓存（set中的参数含义：key值，user对象，缓存存在时间10（long类型），时间单位）
                    redisUtils.set(key,jsApiTicket_matte,cacheLongTime, TimeUnit.SECONDS);
                }else {
                    jsApiTicket_matte =  redisUtils.get(key).toString();
                }
            } finally {
                jsRefreshing_matte.set(false);
            }
        } else {
            jsApiTicket_matte = null;
        }
        return jsApiTicket_matte;
    }

    /**
     * 功能描述: <br> 获取token
     */
    private void initToken_matte(final long refreshTime) {
        log.debug("开始初始化access_token........");
        //记住原本的时间，用于出错回滚
        final long oldTime = this.weixinTokenStartTime_matte;
        this.weixinTokenStartTime_matte = refreshTime;
        String url = WX_TOKEN_URL +"?corpid="+WX_CORPID + "&corpsecret=" + WX_SECRET_MATTE;

        NetWorkCenter.get(url, null, new NetWorkCenter.ResponseCallback() {
            @Override
            public void onResponse(int resultCode, String resultJson) {
                if (HttpStatus.SC_OK == resultCode) {
                    GetTokenResponse response = JSONUtil.toBean(resultJson, GetTokenResponse.class);
                    log.debug("获取access_token:{}", response.getAccessToken());
                    if (null == response.getAccessToken()) {
                        //刷新时间回滚
                        weixinTokenStartTime_matte = oldTime;
                        if(!Refreshing_matte.getAndSet(true)){
                            initToken_matte(weixinTokenStartTime_matte);
                        }
                        log.error("微信公众号token获取出错，错误信息:" + response.getErrcode() + "," + response.getErrmsg());
                    }else {
                        accessToken_matte = response.getAccessToken();
                        Refreshing_matte.set(false);
                    }
                }
            }
        });

    }
    /**
     * 功能描述: <br>初始化微信JS-SDK，获取JS-SDK token
     */
    private void initJSToken_matte(final long refreshTime) {
        log.debug("初始化 jsapi_ticket........");
        //记住原本的时间，用于出错回滚
        final long oldTime = this.jsTokenStartTime_matte;
        this.jsTokenStartTime_matte = refreshTime;
        String url = WX_JSTIKET_URL + accessToken_matte;
        NetWorkCenter.get(url, null, new NetWorkCenter.ResponseCallback() {
            @Override
            public void onResponse(int resultCode, String resultJson) {
                if (HttpStatus.SC_OK == resultCode) {
                    GetJsApiTicketResponse response = JSONUtil.toBean(resultJson, GetJsApiTicketResponse.class);
                    log.debug("获取jsapi_ticket:{}", response.getTicket());
                    if (StrUtil.isBlank(response.getTicket())) {
                        //刷新时间回滚
                        jsTokenStartTime_matte = oldTime;
                        log.error("微信公众号jsToken获取出错，错误信息:" + response.getErrcode() + "," + response.getErrmsg());
                    }else {
                        jsApiTicket_matte = response.getTicket();
                    }
                }
            }
        });
    }


    //========================================================考勤部分结束============================================



    /**
     * 根据基础平台appid获取微信token
     */
    public Map<String,Object> getaccessTokenByPlatformAppid(String appid){
        Map<String,Object> map = new HashMap<>();
        String accessToken = "";
        if(PLATFORM_APPID_MEETING.equals(appid)){
            accessToken = getaccessToken_meeting();
            map.put("refreshTime",weixinTokenStartTime_meeting+"");
        }
        if(PLATFORM_APPID_DAILY.equals(appid)){
            accessToken = getaccessToken_daily();
            map.put("refreshTime",weixinTokenStartTime_daily+"");
        }
        if(PLATFORM_APPID_APPROVE.equals(appid)){
            accessToken = getaccessToken_approve();
            map.put("refreshTime",weixinTokenStartTime_approve+"");
        }
        if(PLATFORM_APPID_NOTICE.equals(appid)){
            accessToken = getaccessToken_notice();
            map.put("refreshTime",weixinTokenStartTime_notice+"");
        }
        if(PLATFORM_APPID_LAW.equals(appid)){
            accessToken = getaccessToken_law();
            map.put("refreshTime",weixinTokenStartTime_law+"");
        }
        if(PLATFORM_APPID_MATTE.equals(appid)){
            accessToken = getaccessToken_matte();
            map.put("refreshTime",weixinTokenStartTime_matte+"");
        }
        map.put("accessToken",accessToken);
        return map;
    }

    /**
     * 根据基础平台appid获取微信jsapi ticket
     * @param appid
     * @return
     */
    public  Map<String,Object>  getJsApiTicketByPlatformAppid(String appid){
        Map<String,Object> map = new HashMap<>();
        String ticket = "";
        if(PLATFORM_APPID_MEETING.equals(appid)){
            ticket = getJsApiTicket_meeting();
            map.put("refreshTime",jsTokenStartTime_meeting+"");
        }
        if(PLATFORM_APPID_DAILY.equals(appid)){
            ticket = getJsApiTicket_daily();
            map.put("refreshTime",jsTokenStartTime_daily+"");
        }
        if(PLATFORM_APPID_APPROVE.equals(appid)){
            ticket = getJsApiTicket_approve();
            map.put("refreshTime",jsTokenStartTime_approve+"");
        }
        if(PLATFORM_APPID_NOTICE.equals(appid)){
            ticket = getJsApiTicket_notice();
            map.put("refreshTime",jsTokenStartTime_notice+"");
        }
        if(PLATFORM_APPID_LAW.equals(appid)){
            ticket = getJsApiTicket_law();
            map.put("refreshTime",jsTokenStartTime_law+"");
        }
        if(PLATFORM_APPID_MATTE.equals(appid)){
            ticket = getJsApiTicket_matte();
            map.put("refreshTime",jsTokenStartTime_matte+"");
        }

        map.put("ticket",ticket);
        return map;

    }


}
