/*时间控件格式转换*/
export function GMTToStrTime(time){
	if(time==undefined||time==null||time==""){
		return "";
	}else{
		let date = new Date(time);
		let y = date.getFullYear();
		let m = date.getMonth() + 1;
		let d = date.getDate();
		
		let hh =date.getHours() < 10? "0" + date.getHours(): date.getHours();
		let mm =date.getMinutes() < 10? "0" + date.getMinutes(): date.getMinutes();
		let ss =date.getSeconds() < 10? "0" + date.getSeconds(): date.getSeconds();

		return y + "-" + (m < 10 ? "0" + m : m) + "-" + (d < 10 ? "0" + d : d)+" "+hh+":"+mm+":"+ss;
	}
}
export function GMTToStr(time){
	if(time==undefined||time==null||time==""){
		return "";
	}else{
		let date = new Date(time);
		let y = date.getFullYear();
		let m = date.getMonth() + 1;
		let d = date.getDate();
		return y + "-" + (m < 10 ? "0" + m : m) + "-" + (d < 10 ? "0" + d : d);
	}
}
export function GMTToStrOfYM(time){
	if(time==undefined||time==null||time==""){
		return "";
	}else{
		let date = new Date(time);
		let y = date.getFullYear();
		let m = date.getMonth() + 1;
		let d = date.getDate();
		return y + "-" + (m < 10 ? "0" + m : m);
	}
}
/*时间控件格式转换 年份*/
export function GMTToStrYear(time){
	if(time==undefined||time==null||time==""){
		return "";
	}else{
		let date = new Date(time);
		let y = date.getFullYear();
		return y;
	}
}
//获取当期日期字符串
export function nowGMTToStr() {
	let date = new Date();
	let y = date.getFullYear();
	let m = date.getMonth() + 1;
	let d = date.getDate();
	return y + "-" + (m < 10 ? "0" + m : m) + "-" + (d < 10 ? "0" + d : d)
}
//获取日期前N天的日期
export function dateOfBefore(time,days){
	let date = new Date(time);
	date.setDate(date.getDate()-days);
	let y = date.getFullYear();
	let m = date.getMonth() + 1;
	let d = date.getDate();
	return y + "-" + (m < 10 ? "0" + m : m) + "-" + (d < 10 ? "0" + d : d);
}

//判断开始日期和截至日期输入是否合法,开始日期小于截至日期返回-1,等于返回0，否则返回-1
export function compareDate(startDate,endDate){
	//将字符串转换为日期
    var begin=new Date(startDate.replace(/-/g,"/"));
    var end=new Date(endDate.replace(/-/g,"/"));
    if(begin-end == 0){
    	return 0;
    }else if(begin<end){
    	return -1;
    }else{
    	return 1;
    }
}
/**
 * 为请求参数拼接processor相关信息
 */
export function makeParam(param){
	let user = sessionStorage.getItem('user');
	user = JSON.parse(user);
	let userUnit = sessionStorage.getItem('userUnit');
	userUnit = JSON.parse(userUnit);
	let userBranch = sessionStorage.getItem('userBranch');
	userBranch = JSON.parse(userBranch);
	let userOrg = sessionStorage.getItem('userOrg');
	userOrg = JSON.parse(userOrg);
	let orgCreditUnitId = sessionStorage.getItem('orgCreditUnitId');
	let tempParam = "";
	if(param!=null && param !="")
	{
		tempParam+=param;
	}
	if(user!=null){
		tempParam += "&processor.currentUserId=" + user.userId
				  +"&processor.currentUserName=" + user.username;
	}
	let unitScope="";
	if(userUnit!=null)
	{
		for(var i=0;i<userUnit.length;i++){
			unitScope += userUnit[i].unitId+",";
		}
		if(unitScope.length>0){
			unitScope = unitScope.substring(0,unitScope.length-1);
		}
		tempParam += "&processor.unitScope=" + unitScope;
	}
	if(userBranch!=null)
	{
		let branchScope="";
		for(var i=0;i<userBranch.length;i++){
			branchScope += userBranch[i].branchId+",";
		}
		if(branchScope.length>0){
			branchScope = branchScope.substring(0,branchScope.length-1);
		}
		tempParam += "&processor.branchScope=" + branchScope;
	}
	if(userOrg!=null)
	{
		tempParam += "&processor.orgCode=" + userOrg.orgCode;
		tempParam += "&processor.orgName=" + userOrg.orgName;
	}
	if(orgCreditUnitId != null && orgCreditUnitId != "")
	{
		tempParam += "&processor.orgCreditUnitId=" + orgCreditUnitId;
	}
	return tempParam;
					
}

export default{
	GMTToStr,
	nowGMTToStr,
	dateOfBefore,
	makeParam,
	compareDate,
	GMTToStrYear,
	GMTToStrOfYM,
	GMTToStrTime,
}
