export default ({ app, router, store, Vue }) => {
    Vue.directive('permission', {
        bind: function (el, binding, vnode) {
            let needPermissions = binding.value[0];
            let permissions = JSON.parse(sessionStorage.getItem('permission'));
            let newpermissions = [];
             permissions.forEach(element => {
                 if(element.code){
                    newpermissions.push(element.code);  
                 }
             });
            let isAdmin=sessionStorage.getItem('isAdmin');
            let hasPermission = newpermissions.some(s => {
                return needPermissions.indexOf(s) > -1;
            })
            if (!hasPermission&&isAdmin==0) {
                el.style.display = "none";
            }
        }
    })
}