import request from '@/libs/request'
/**
 *  列表
 * @param {*} query 
 */
export function getSysCodelistPagedList(query) {
  
  return request({
    url: '/syscodelist/pagedlist',
    method: 'get',
    params: query
  })
}
/**
 * 删除用户
 * @param {id} id 
 */
export function delSysCodelist(id) {
  return request({
    url: '/syscodelist/delete',
    method: 'delete',
    params: id,
    loading: "hourglass"
  })
}
 /**
 * 更新启停状态
 * @param {*} data 
 */
export function updateSysCodelistStatus(data) {
  
  return request({
    url: '/syscodelist/updatestatus',
    method: 'put',
    params: data,
    loading: "hourglass"
  })
}
/**
 * 新增
 * @param {} data 
 */
export function saveSysCodelist(data) {
  
  return request({
    url: '/syscodelist/add',
    method: 'post',
    data: data,
    loading: "hourglass"
  })
}
/**
 * 修改
 * @param {*} data 
 */
export function editSysCodelist(data) {
  return request({
    url: '/syscodelist/update',
    method: 'put',
    data: data,
    loading: "hourglass"
  })
}
/**
 * 查看
 */
export function loadSysCodelist(data) {
  return request({
    url: '/syscodelist/load',
    method: 'get',
    data: data,
    loading: "hourglass"
  })
}
export function updateSysCodelistsStatus(ids, status) {
  
  return request({
    url: '/syscodelist/updateSysCodelistStatus',
    method: 'put',
    params: { "ids": ids, "status": status },
    loading: "hourglass"
  })
}
export function getSysCodelistByKindcode(kindcode) {
  
  return request({
    url: '/syscodelist/getSysCodelistByKindcode',
    method: 'get',
    params: { "kindcode": kindcode},
    loading: "hourglass"
  })
}
export function countByExample(id) {
  
  return request({
    url: '/syscodelist/countByExample',
    method: 'get',
    params: id,
    loading: "hourglass"
  })
}