import request from '@/libs/request'

export function editUserFromwx(id) {
  return request({
      url: '/user/updateWxPlatformPersonnelByUserid/',
      method: 'post',
      params:{"userid":id},
      loading:"hourglass"
  })
}
export function getUserList() {
  return request({
    url: '/user/userlist',
    method: 'get'
  })
}
export function getUserListByPid(pid) {
  return request({
    url: '/department/listbypid/'+pid,
    method: 'get'
  })
}
export function getUserPagedList(query) {
  
  return request({
    url: '/user/pagedlist',
    method: 'get',
    params: query
  })
}

export function getUserRolePagedList(query) {
  return request({
    url: '/roleuser/roleuserpagedlist',
    method: 'get',
    params: query,
    loading:"hourglass"
  })
}

export function getUserRoleList(query) {
  return request({
    url: '/roleuser/roleuserlist',
    method: 'get',
    params: query,
    loading:"hourglass"
  })
}

export function delUser(id) {
  return request({
      url: '/user/del',
      method: 'post',
      params: id,
      loading:"hourglass"
  })
}

export function delUsers(ids) {
  return request({
      url: '/user/batchdel',
      method: 'post',
      params:ids,
      loading:"hourglass"
  })
}
export function resetPassword(id) {
  return request({
      url: '/user/resetPassword/',
      method: 'post',
      params:{"id":id},
      loading:"hourglass"
  })
}
export function updateUsersStatus(ids,status) {
  
  return request({
      url: '/user/updateUsersStatus',
      method: 'post',
      params:{"ids":ids,"status":status},
      loading:"hourglass"
  })
}
export function saveUser(data) {
  return request({
      url: '/user/save',
      method: 'post',
      data: data,
      loading:"hourglass"
  })
}
export function saveUserNoPassword(data) {
  return request({
      url: '/user/savenopassword',
      method: 'post',
      data: data,
      loading:"hourglass"
  })
}
export function editRoleUser(data){
  return request({
      url: '/roleuser/editroleuser',
      method: 'post',
      data: data,
      loading:"hourglass"
  })
}
export function delUserRole(data){
  return request({
      url: '/roleuser/delUserRole',
      method: 'post',
      data: data,
      loading:"hourglass"
  })
}
export function synchronousDept(){
  return request({
      url: '/user/synchronousDept',
      method: 'get',
      data:''
//    loading:"hourglass"
  })
}
export function getDeltetList_user(){
  return request({
      url: '/user/getDeltetList',
      method: 'get',
      data:''
//    loading:"hourglass"
  })
}
export function synchronousAvatar(){
  return request({
      url: '/user/synchronousAvatar',
      method: 'get',
      data:''
//    loading:"hourglass"
  })
}
/**
  *同步微信新增人员
  */
export function synchronousPersonal(){
  return request({
      url: '/user/synchronousPersonal',
      method: 'get',
      data:''
  })
}
export function getweixinisleaderindeptByaccount(){
  return request({
      url: '/user/getweixinisleaderindeptByaccount',
      method: 'get',
      data:'',
      loading:"hourglass"
  })
}
  /**密码修改 */
  export function pagedlistByToken(query) {
    return request({
      url: '/user/pagedlistByToken',
      method: 'get',
      params: query
    })
  }
  /**验证密码 */
  export function checkpassword(password) {
    return request({
      url: '/user/checkpassword',
      method: 'get',
      params: { "password": password},
    })
  }
  /**更新密码 */
  export function updatepassword(password) {
    return request({
      url: '/user/updatepassword',
      method: 'post',
      params: { "password": password},
    })
  }

  export function deptall() {
    return request({
        url: '/user/view_deptall',
        method: 'get',
        params: "",
        loading:"gears"
    })
  }

  export function editUserRoleList(params) {
    return request({
        url: '/roleuser/editUserRoleList',
        method: 'post',
        data:params,
        loading:"hourglass"
    })
  }
  export function updateRedis(){
  	    return request({
        url: '/meeting/updateRedis',
        method: 'get',
        data:"",
        loading:"hourglass"
    })
  }

    
  export function pagedlistWeixin(query) {
    return request({
      url: '/user/pagedlist_weixin',
      method: 'get',
      params: query
    })
  }

  export function updatePlatformpersonnel(data){
    return request({
        url: '/user/update_platformpersonnel',
        method: 'post',
        data: data,
        loading:"hourglass"
    })
  }
  