import request from '@/libs/request'

export function getPlatformApplicationsPagedList(query) {
    return request({
        url: '/PlatformApplicationsController/platformapplications/pagedlist',
        method: 'get',
        params: query
    })
}

export function saveapp(data) {
    return request({
        url: '/PlatformApplicationsController/save',
        method: 'post',
        data: data,
        loading:"hourglass"
    })
}

export function delapp(id) {
    return request({
        url: '/PlatformApplicationsController/del',
        method: 'delete',
        params: id,
        loading:"hourglass"
    })
}

export function getAllApps() {
    return request({
        url: '/PlatformApplicationsController/platformapplications/listall',
        method: 'get'
    })
}

export function updateOrder(list) {
    return request({
        url: '/PlatformApplicationsController/platformapplications/updateOrder',
        method: 'post',
        data: list,
        loading: "hourglass"
    })
}

export function updateWechatNum(list) {
    return request({
        url: '/PlatformApplicationsController/platformapplications/updateWechatNum',
        method: 'post',
        data: list,
        loading: "hourglass"
    })
}

// 验证应用唯一标识是否唯一
export function checkAppidUnique(appid, excludeId = null) {
    return request({
        url: '/PlatformApplicationsController/platformapplications/checkAppidUnique',
        method: 'get',
        params: { appid, excludeId }
    })
}

// 验证待办标识是否唯一
export function checkMailtypeUnique(mailtype, excludeId = null) {
    return request({
        url: '/PlatformApplicationsController/platformapplications/checkMailtypeUnique',
        method: 'get',
        params: { mailtype, excludeId }
    })
}