import request from '@/libs/request'
/**
 *  列表
 * @param {*} query 
 */
export function getHolidayPagedList(query) {
  
  return request({
    url: '/sysholiday/pagedlist',
    method: 'get',
    params: query
  })
}

/**
 * 删除用户
 * @param {id} id 
 */
export function delHoliday(id) {
  return request({
    url: '/sysholiday/delete',
    method: 'post',
    params: id,
    loading: "hourglass"
  })
}
 /**
 * 更新启停状态
 * @param {*} data 
 */
export function updateHolidayStatus(data) {
  
  return request({
    url: '/sysholiday/updatestatus',
    method: 'post',
    params: data,
    loading: "hourglass"
  })
}
/**
 * 新增
 * @param {} data 
 */
export function saveHoliday(data) {
  
  return request({
    url: '/sysholiday/add',
    method: 'post',
    data: data,
    loading: "hourglass"
  })
}
/**
 * 修改
 * @param {*} data 
 */
export function editHoliday(data) {
  return request({
    url: '/sysholiday/update',
    method: 'post',
    data: data,
    loading: "hourglass"
  })
}
/**
 * 查看
 */
export function loadHoliday(data) {
  return request({
    url: '/sysholiday/load',
    method: 'get',
    data: data,
    loading: "hourglass"
  })
}
export function updateHolidaysStatus(ids, status) {
  
  return request({
    url: '/sysholiday/updateHolidayStatus',
    method: 'post',
    params: { "ids": ids, "status": status },
    loading: "hourglass"
  })
}
export function getSysHolidayListByTypeAndNum(type, num) {
  
  return request({
    url: '/sysholiday/getSysHolidayListByTypeAndNum',
    method: 'get',
    params: { "type": type, "num": num },
    loading: "hourglass"
  })
}