import request from '@/libs/request'
/**
 *  列表
 * @param {*} query 
 */
export function getAdvPagedList(query) {
  
  return request({
    url: '/sysadv/pagedlist',
    method: 'get',
    params: query
  })
}

/**
 * 删除用户
 * @param {id} id 
 */
export function delAdv(id) {
  return request({
    url: '/sysadv/delete',
    method: 'post',
    params: id,
    loading: "hourglass"
  })
}
 /**
 * 更新启停状态
 * @param {*} data 
 */
export function updateAdvStatus(data) {
  
  return request({
    url: '/sysadv/updatestatus',
    method: 'post',
    params: data,
    loading: "hourglass"
  })
}
/**
 * 新增
 * @param {} data 
 */
export function saveAdv(data) {
  
  return request({
    url: '/sysadv/add',
    method: 'post',
    data: data,
    loading: "hourglass"
  })
}
/**
 * 修改
 * @param {*} data 
 */
export function editAdv(data) {
  return request({
    url: '/sysadv/update',
    method: 'post',
    data: data,
    loading: "hourglass"
  })
}
/**
 * 查看
 */
export function loadAdv(data) {
  return request({
    url: '/sysadv/load',
    method: 'get',
    params: data,
    loading: "hourglass"
  })
}
export function updateAdvsStatus(ids, status) {
  
  return request({
    url: '/sysadv/updateSysAdvStatus',
    method: 'post',
    params: { "ids": ids, "status": status },
    loading: "hourglass"
  })
}
export function getSysAdvListByTypeAndNum(type, num) {
  
  return request({
    url: '/sysadv/getSysAdvListByTypeAndNum',
    method: 'get',
    params: { "type": type, "num": num },
    loading: "hourglass"
  })
}
export function uploadfile(data) {
  
  return request({
    url: '/znzl/file/upload/videoandimgurl?uploadPar=adv',
    method: 'post',
    data:data,
    loading: "hourglass"
  })
}