import request from '@/libs/request'

/**
 * 分页获取地铁工作菜单列表
 * @param {Object} query - 查询参数
 * @param {number} query.page - 页码
 * @param {number} query.size - 每页大小
 * @param {string} query.name - 菜单名称（可选）
 * @param {string} query.code - 菜单编码（可选）
 */
export function getMetroworkMenuList(query) {
  return request({
    url: '/metrowork/admin/list',
    method: 'get',
    params: query,
    loading: 'gears'
  })
}

/**
 * 获取单个地铁工作菜单详情
 * @param {string} id - 菜单ID
 */
export function getMetroworkMenu(id) {
  return request({
    url: `/metrowork/admin/${id}`,
    method: 'get',
    loading: 'gears'
  })
}

/**
 * 新增地铁工作菜单
 * @param {Object} data - 菜单数据
 */
export function saveMetroworkMenu(data) {
  return request({
    url: '/metrowork/admin/save',
    method: 'post',
    data: data,
    loading: 'hourglass'
  })
}

/**
 * 更新地铁工作菜单
 * @param {Object} data - 菜单数据
 */
export function updateMetroworkMenu(data) {
  return request({
    url: '/metrowork/admin/update',
    method: 'put',
    data: data,
    loading: 'hourglass'
  })
}

/**
 * 删除地铁工作菜单
 * @param {string} id - 菜单ID
 */
export function deleteMetroworkMenu(id) {
  return request({
    url: `/metrowork/admin/${id}`,
    method: 'delete',
    loading: 'hourglass'
  })
}

/**
 * 启用地铁工作菜单
 * @param {string} id - 菜单ID
 */
export function enableMetroworkMenu(id) {
  return request({
    url: `/metrowork/admin/${id}/enable`,
    method: 'put',
    loading: 'hourglass'
  })
}

/**
 * 停用地铁工作菜单
 * @param {string} id - 菜单ID
 */
export function disableMetroworkMenu(id) {
  return request({
    url: `/metrowork/admin/${id}/disable`,
    method: 'put',
    loading: 'hourglass'
  })
}

/**
 * 获取启用的地铁工作菜单（前端调用）
 */
export function getEnabledMetroworkMenus() {
  return request({
    url: '/metrowork/menus',
    method: 'get',
    loading: 'gears'
  })
}
