# 应用分组管理功能需求文档

## 1. 项目背景
基于现有的应用分组(`platformapplicationsGroup`)和应用管理(`platformapplications`)功能，需要开发一个新的管理页面，实现应用分组的拖拽排序以及向分组中添加应用的可视化操作。

## 2. 功能需求

### 2.1 核心功能
1. **应用分组拖拽排序**
   - 支持应用分组列表的拖拽重新排序
   - 拖拽后自动更新排序索引(sortIndex)
   - 实时保存排序结果到后端

2. **应用分组内应用管理**
   - 左侧显示应用分组列表（可拖拽排序）
   - 右侧显示当前选中分组内的应用列表
   - 支持从所有应用池中选择应用添加到分组
   - 支持从分组中移除应用

### 2.2 界面布局
```
+----------------------------------+
| 应用分组管理                     |
+----------------------------------+
| 左侧：分组列表    | 右侧：应用管理 |
| (可拖拽排序)      |                |
|                   | 当前分组应用   |
| - 分组1           | +-----------+  |
| - 分组2           | | 应用1     |  |
| - 分组3           | | 应用2     |  |
|                   | +-----------+  |
| [添加分组]        | [添加应用]     |
+-------------------+----------------+
```

## 3. 技术实现

### 3.1 数据结构
基于现有数据结构：
- **应用分组**：包含`id`, `groupName`, `groupCode`, `sortIndex`
- **应用**：包含`id`, `title`, `groupCode`, 以及其他应用相关字段

### 3.2 新增API需求
需要后端提供以下API（假设）：
```javascript
// 更新分组排序
updateApplicationsGroupSort(data) {
    return request({
        url: '/applicationsGroup/updateSort',
        method: 'post',
        data: data
    })
}

// 获取分组中的应用列表
getApplicationsByGroup(groupCode) {
    return request({
        url: '/platformapplications/byGroup',
        method: 'get',
        params: { groupCode }
    })
}

// 将应用添加到分组
addApplicationToGroup(data) {
    return request({
        url: '/platformapplications/addToGroup',
        method: 'post',
        data: data
    })
}

// 从分组中移除应用
removeApplicationFromGroup(data) {
    return request({
        url: '/platformapplications/removeFromGroup',
        method: 'post',
        data: data
    })
}
```

### 3.3 前端组件设计
1. **分组列表组件**
   - 使用Quasar的`q-list`和拖拽功能
   - 支持拖拽排序
   - 点击选中分组

2. **应用管理组件**
   - 当前分组应用列表
   - 添加应用对话框（从所有应用中选择）
   - 移除应用确认

3. **拖拽排序实现**
   - 使用HTML5拖拽API或第三方拖拽库
   - 实时更新排序索引
   - 批量保存排序结果

## 4. 路由配置
在现有路由基础上添加新页面：
```javascript
{
    path: 'platformapplicationsGroupManager',
    name: 'platformapplicationsGroupManager',
    component: () => import('pages/platformapplicationsGroup/platformapplicationsGroupManager.vue')
}
```

## 5. 菜单配置
在权限管理菜单下添加新菜单项：
```javascript
{
    path: "platformapplicationsGroupManager",
    icon: "settings",
    title: "应用分组管理",
    name: "platformapplicationsGroupManager",
    leftmemu: true
}
```

## 6. 用户体验要求
1. **拖拽体验**
   - 拖拽时有视觉反馈
   - 拖拽结束后自动保存
   - 保存成功/失败有提示

2. **操作便捷性**
   - 点击分组即可查看和管理内部应用
   - 添加应用支持搜索和筛选
   - 移除应用需要确认提示

3. **响应式设计**
   - 适配不同屏幕尺寸
   - 移动端友好的触控操作

## 7. 技术栈
- **前端框架**：Vue.js + Quasar Framework
- **拖拽功能**：原生HTML5拖拽API或SortableJS
- **状态管理**：Vuex（如需）
- **HTTP请求**：基于现有request封装

## 8. 开发计划
1. 创建页面组件和路由配置
2. 实现分组列表拖拽排序功能
3. 实现应用管理功能（添加/移除）
4. 集成API接口
5. 优化用户体验和界面
6. 测试和调试

请确认这个需求文档是否符合您的预期，如有需要调整的地方请指出，确认后我将开始实现该功能。