import request from '@/libs/request'
/**
 *  列表
 * @param {*} query 
 */
export function getRecipesPagedList(query) {
  
  return request({
    url: '/sysrecipes/pagedlist',
    method: 'get',
    params: query
  })
}

/**
 * 删除
 * @param {id} id 
 */
export function delRecipes(id) {
  return request({
    url: '/sysrecipes/delete',
    method: 'post',
    params: id,
    loading: "hourglass"
  })
}
 /**
 * 更新启停状态
 * @param {*} data 
 */
export function updateRecipesStatus(data) {
  
  return request({
    url: '/sysrecipes/updatestatus',
    method: 'post',
    params: data,
    loading: "hourglass"
  })
}
/**
 * 新增
 * @param {} data 
 */
export function saveRecipes(data) {
  
  return request({
    url: '/sysrecipes/add',
    method: 'post',
    data: data,
    loading: "hourglass"
  })
}
/**
 * 修改
 * @param {*} data 
 */
export function editRecipes(data) {
  return request({
    url: '/sysrecipes/update',
    method: 'post',
    data: data,
    loading: "hourglass"
  })
}
/**
 * 查看
 */
export function loadRecipes(data) {
  return request({
    url: '/sysrecipes/load',
    method: 'get',
    data: data,
    loading: "hourglass"
  })
}
export function updateRecipessStatus(ids, status) {
  
  return request({
    url: '/sysrecipes/updateRecipesStatus',
    method: 'post',
    params: { "ids": ids, "status": status },
    loading: "hourglass"
  })
}
export function saveexceldata(data) {
  
  return request({
    url: '/sysrecipes/saveexceldata',
    method: 'post',
    params: data,
    loading: "hourglass"
  })
}