import request from '@/libs/request'
import qs from 'qs'

export function loginByUsername(username, password) {
  const data = {
    "account":username,
    "password":password
  }
  return request({
    url: '/auth/v1/login',
    method: 'post',
    data: data//qs.stringify(data)
  })
}

export function logout() {
  return request({
    url: '/auth/v1/logout',
    method: 'post',
    loading:"hourglass"
  })
}

export function getUserInfo() {
	
  return request({
    url: '/auth/v1/user',
    method: 'get',
    loading:"gears"
  })
}