import request from '@/libs/request'
/**
 *  列表
 * @param {*} query 
 */
export function getDeptPagedList(query) {
  
  return request({
    url: '/department/pagedlist',
    method: 'get',
    params: query
  })
}

/**
 * 删除用户
 * @param {id} id 
 */
export function delDept(id) {
  return request({
    url: '/department/delete',
    method: 'delete',
    params: id,
    loading: "hourglass"
  })
}
export function countByExample(id) {
  
  return request({
    url: '/department/countByExample',
    method: 'get',
    params: id,
    loading: "hourglass"
  })
}
export function searchAccount(name) {
  
  return request({
    url: '/department/searchAccount',
    method: 'get',
    params: name,
    loading: "hourglass"
  })
}
/**
 * 更新启停状态
 * @param {*} data 
 */
export function updateDeptStatus(data) {
  
  return request({
    url: '/department/updatestatus',
    method: 'put',
    params: data,
    loading: "hourglass"
  })
}
/**
 * 新增
 * @param {} data 
 */
export function saveDept(data) {
  
  return request({
    url: '/department/add',
    method: 'post',
    data: data,
    loading: "hourglass"
  })
}
/**
 * 修改
 * @param {*} data 
 */
export function editDept(data) {
  return request({
    url: '/department/update',
    method: 'put',
    data: data,
    loading: "hourglass"
  })
}
/**
 * 查看
 */
export function loadDept(data) {
  return request({
    url: '/department/load',
    method: 'get',
    data: data,
    loading: "hourglass"
  })
}
export function updateDeptsStatus(ids, status) {
  
  return request({
    url: '/department/updateDeptStatus',
    method: 'put',
    params: { "ids": ids, "status": status },
    loading: "hourglass"
  })
}
/**
  *同步微信新增部门
  */
export function findwxDeptinfo(){
  return request({
      url: '/department/findwxDeptinfo',
      method: 'get',
      data:'',
      loading:"hourglass"
  })
}
  export function updateRedis(){
  	    return request({
        url: '/meeting/updateRedis',
        method: 'get',
        data:"",
        loading:"hourglass"
    })
  }