package com.ruoyi.inventory.service;

import java.util.List;
import com.ruoyi.inventory.domain.StorageLocations;

/**
 * 库位Service接口
 * 
 * @author ruoyi
 * @date 2025-12-01
 */
public interface IStorageLocationsService 
{
    /**
     * 查询库位
     * 
     * @param id 库位主键
     * @return 库位
     */
    public StorageLocations selectStorageLocationsById(String id);

    /**
     * 查询库位
     *
     * @param warehousesCode 库位主键
     * @return 库位
     */
    public List<StorageLocations> selectStorageLocationsByWarehousesCode(String warehousesCode);

    /**
     * 查询库位
     *
     * @param warehousesCodes 库位主键
     * @return 库位
     */
    public List<StorageLocations> selectStorageLocationsByWarehousesCodes(String[] warehousesCodes);

    /**
     * 查询库位列表
     * 
     * @param storageLocations 库位
     * @return 库位集合
     */
    public List<StorageLocations> selectStorageLocationsList(StorageLocations storageLocations);

    /**
     * 新增库位
     * 
     * @param storageLocations 库位
     * @return 结果
     */
    public int insertStorageLocations(StorageLocations storageLocations);

    /**
     * 修改库位
     * 
     * @param storageLocations 库位
     * @return 结果
     */
    public int updateStorageLocations(StorageLocations storageLocations);

    /**
     * 批量删除库位
     * 
     * @param ids 需要删除的库位主键集合
     * @return 结果
     */
    public int deleteStorageLocationsByIds(String[] ids);

    /**
     * 删除库位信息
     * 
     * @param id 库位主键
     * @return 结果
     */
    public int deleteStorageLocationsById(String id);

    int updateLocationsCategoryStatus(String id);
}
