import request from '@/utils/request'

// 查询退库单明细列表
export function listReturnOrderItems(query) {
  return request({
    url: '/inventory/return_order_items/list',
    method: 'get',
    params: query
  })
}

// 查询退库单明细详细
export function getReturnOrderItem(id) {
  return request({
    url: '/inventory/return_order_items/' + id,
    method: 'get'
  })
}

// 新增退库单明细
export function addReturnOrderItem(data) {
  return request({
    url: '/inventory/return_order_items',
    method: 'post',
    data: data
  })
}

// 修改退库单明细
export function updateReturnOrderItem(data) {
  return request({
    url: '/inventory/return_order_items',
    method: 'put',
    data: data
  })
}

// 删除退库单明细
export function delReturnOrderItem(id) {
  return request({
    url: '/inventory/return_order_items/' + id,
    method: 'delete'
  })
}

// 导出退库单明细
export function exportReturnOrderItems(query) {
  return request({
    url: '/inventory/return_order_items/export',
    method: 'post',
    params: query
  })
}

