package com.ruoyi.inventory.domain;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 退库单明细对象 return_order_items
 *
 * @author cy
 * @date 2025-12-03
 */

@Data
public class ReturnOrderItems extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 编号 */
    private String id;

    /** 退库单号 检索条件 */
    @Excel(name = "退库单号")
    private String orderId;

    /** 货物ID 字典，检索条件 */
    @Excel(name = "货物编码")
    private String materialCode;

    /** 物料名称（关联查询） */
    @Excel(name = "货物名称")
    private String materialName;

    /** 批次ID 检索条件 */
    @Excel(name = "批次")
    private String batchCode;

    /** 仓库ID 检索条件 */
    @Excel(name = "仓库ID")
    private String warehouseId;

    /** 库位ID 检索条件 */
    @Excel(name = "库位ID")
    private String locationId;

    /** 计划数量 */
    @Excel(name = "计划数量")
    private Integer plannedQuantity;

    /** 实际数量 */
    @Excel(name = "实际数量")
    private Integer actualQuantity;

    /** 计划件数 暂无用 */
    @Excel(name = "计划件数")
    private Integer plannedPackages;

    /** 实际件数 暂无用 */
    @Excel(name = "实际件数")
    private Integer actualPackages;

    /** 约数 暂无用 */
    @Excel(name = "约数")
    private Double divisor;

    /** 标签颜色 暂无用 */
    @Excel(name = "标签颜色")
    private Integer labelColor;

    /** 凭证号 暂无用 */
    @Excel(name = "凭证号")
    private String voucherNumber;

    /** 单价 */
    @Excel(name = "单价")
    private Double unitPrice;

    /** 金额，实数乘单价 统计用 */
    @Excel(name = "金额")
    private Double totalAmount;

    /** 应用数据1使用0删除 删除用 */
    @Excel(name = "应用数据")
    private Integer isUsed;

    /** 排序 */
    @Excel(name = "排序")
    private Integer sortNo;

    /** 创建人代码 */
    @Excel(name = "创建人代码")
    private String createUserCode;

    /** 更新人代码 */
    @Excel(name = "更新人代码")
    private String updateUserCode;

    /** 退库日期（关联查询） */
    private java.util.Date returnDate;

    /** 货主名称（关联查询） */
    private String ownerName;

    /** 货物ID 字典，检索条件 */
    private String materialId;

    /** 仓库名称（关联查询） */
    private String warehouseName;

    /** 库位名称（关联查询） */
    private String locationName;

    /** 开始日期（查询条件） */
    private String startDate;

    /** 结束日期（查询条件） */
    private String endDate;

    /** 货主ID（查询条件） */
    private String ownerId;

    /** 退库单ID */
    private String returnOrderId;

    public void setId(String id)
    {
        this.id = id;
    }

    public String getId()
    {
        return id;
    }

    public void setOrderId(String orderId)
    {
        this.orderId = orderId;
    }

    public String getOrderId()
    {
        return orderId;
    }

    public void setMaterialId(String materialId)
    {
        this.materialId = materialId;
    }

    public String getMaterialId()
    {
        return materialId;
    }

    public void setBatchCode(String batchCode)
    {
        this.batchCode = batchCode;
    }

    public String getBatchCode()
    {
        return batchCode;
    }

    public void setWarehouseId(String warehouseId)
    {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseId()
    {
        return warehouseId;
    }

    public void setLocationId(String locationId)
    {
        this.locationId = locationId;
    }

    public String getLocationId()
    {
        return locationId;
    }

    public void setPlannedQuantity(Integer plannedQuantity)
    {
        this.plannedQuantity = plannedQuantity;
    }

    public Integer getPlannedQuantity()
    {
        return plannedQuantity;
    }

    public void setActualQuantity(Integer actualQuantity)
    {
        this.actualQuantity = actualQuantity;
    }

    public Integer getActualQuantity()
    {
        return actualQuantity;
    }

    public void setPlannedPackages(Integer plannedPackages)
    {
        this.plannedPackages = plannedPackages;
    }

    public Integer getPlannedPackages()
    {
        return plannedPackages;
    }

    public void setActualPackages(Integer actualPackages)
    {
        this.actualPackages = actualPackages;
    }

    public Integer getActualPackages()
    {
        return actualPackages;
    }

    public void setDivisor(Double divisor)
    {
        this.divisor = divisor;
    }

    public Double getDivisor()
    {
        return divisor;
    }

    public void setLabelColor(Integer labelColor)
    {
        this.labelColor = labelColor;
    }

    public Integer getLabelColor()
    {
        return labelColor;
    }

    public void setVoucherNumber(String voucherNumber)
    {
        this.voucherNumber = voucherNumber;
    }

    public String getVoucherNumber()
    {
        return voucherNumber;
    }

    public void setUnitPrice(Double unitPrice)
    {
        this.unitPrice = unitPrice;
    }

    public Double getUnitPrice()
    {
        return unitPrice;
    }

    public void setTotalAmount(Double totalAmount)
    {
        this.totalAmount = totalAmount;
    }

    public Double getTotalAmount()
    {
        return totalAmount;
    }

    public void setIsUsed(Integer isUsed)
    {
        this.isUsed = isUsed;
    }

    public Integer getIsUsed()
    {
        return isUsed;
    }

    public void setSortNo(Integer sortNo)
    {
        this.sortNo = sortNo;
    }

    public Integer getSortNo()
    {
        return sortNo;
    }

    public void setCreateUserCode(String createUserCode)
    {
        this.createUserCode = createUserCode;
    }

    public String getCreateUserCode()
    {
        return createUserCode;
    }

    public void setUpdateUserCode(String updateUserCode)
    {
        this.updateUserCode = updateUserCode;
    }

    public String getUpdateUserCode()
    {
        return updateUserCode;
    }

    public void setReturnDate(java.util.Date returnDate)
    {
        this.returnDate = returnDate;
    }

    public java.util.Date getReturnDate()
    {
        return returnDate;
    }

    public void setOwnerName(String ownerName)
    {
        this.ownerName = ownerName;
    }

    public String getOwnerName()
    {
        return ownerName;
    }

    public void setMaterialName(String materialName)
    {
        this.materialName = materialName;
    }

    public String getMaterialName()
    {
        return materialName;
    }

    public void setWarehouseName(String warehouseName)
    {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseName()
    {
        return warehouseName;
    }

    public void setLocationName(String locationName)
    {
        this.locationName = locationName;
    }

    public String getLocationName()
    {
        return locationName;
    }

    public void setStartDate(String startDate)
    {
        this.startDate = startDate;
    }

    public String getStartDate()
    {
        return startDate;
    }

    public void setEndDate(String endDate)
    {
        this.endDate = endDate;
    }

    public String getEndDate()
    {
        return endDate;
    }

    public void setOwnerId(String ownerId)
    {
        this.ownerId = ownerId;
    }

    public String getOwnerId()
    {
        return ownerId;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("orderId", getOrderId())
                .append("materialId", getMaterialId())
                .append("batchCode", getBatchCode())
                .append("warehouseId", getWarehouseId())
                .append("locationId", getLocationId())
                .append("plannedQuantity", getPlannedQuantity())
                .append("actualQuantity", getActualQuantity())
                .append("plannedPackages", getPlannedPackages())
                .append("actualPackages", getActualPackages())
                .append("divisor", getDivisor())
                .append("labelColor", getLabelColor())
                .append("voucherNumber", getVoucherNumber())
                .append("unitPrice", getUnitPrice())
                .append("totalAmount", getTotalAmount())
                .append("remark", getRemark())
                .append("isUsed", getIsUsed())
                .append("sortNo", getSortNo())
                .append("createTime", getCreateTime())
                .append("createUserCode", getCreateUserCode())
                .append("updateTime", getUpdateTime())
                .append("updateUserCode", getUpdateUserCode())
                .toString();
    }
}

