package com.ruoyi.inventory.service;

import java.util.List;
import com.ruoyi.inventory.domain.InventoryTransactions;

/**
 * 库存事务Service接口
 * 
 * @author ruoyi
 * @date 2025-12-02
 */
public interface IInventoryTransactionsService 
{
    /**
     * 查询库存事务
     * 
     * @param id 库存事务主键
     * @return 库存事务
     */
    public InventoryTransactions selectInventoryTransactionsById(String id);

    /**
     * 查询库存事务列表
     * 
     * @param inventoryTransactions 库存事务
     * @return 库存事务集合
     */
    public List<InventoryTransactions> selectInventoryTransactionsList(InventoryTransactions inventoryTransactions);

    /**
     * 新增库存事务
     * 
     * @param inventoryTransactions 库存事务
     * @return 结果
     */
    public int insertInventoryTransactions(InventoryTransactions inventoryTransactions);

    /**
     * 修改库存事务
     * 
     * @param inventoryTransactions 库存事务
     * @return 结果
     */
    public int updateInventoryTransactions(InventoryTransactions inventoryTransactions);

    /**
     * 批量删除库存事务
     * 
     * @param ids 需要删除的库存事务主键集合
     * @return 结果
     */
    public int deleteInventoryTransactionsByIds(String[] ids);

    /**
     * 删除库存事务信息
     * 
     * @param id 库存事务主键
     * @return 结果
     */
    public int deleteInventoryTransactionsById(String id);
}
