package com.ruoyi.inventory.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 库存事务对象 inventory_transactions
 *
 * @author ruoyi
 * @date 2025-12-02
 */
@Data
public class InventoryTransactions extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 编号 */
    private String id;

    /** 类型1-入库 2-出库 3-盘点调整 */
    @Excel(name = "类型1-入库 2-出库 3-盘点调整")
    private Long transactionType;

    // 库存表id
    private String inventoryId;
    /** 关联单号，相当于主记录 */
    @Excel(name = "关联单号，相当于主记录")
    private String referenceId;

    /** 子记录id */
    @Excel(name = "子记录id")
    private String referenceItemId;

    /** 货物ID */
    @Excel(name = "货物ID")
    private String materialId;

    /** 批次ID */
    @Excel(name = "批次ID")
    private String batchCode;

    /** 仓库ID */
    @Excel(name = "仓库ID")
    private String warehouseId;

    /** 库位ID */
    @Excel(name = "库位ID")
    private String locationId;

    /** 货主ID */
    @Excel(name = "货主ID")
    private String ownerId;

    /** 操作前数量 */
    @Excel(name = "操作前数量")
    private Long quantityBefore;

    /** 操作数量 */
    @Excel(name = "操作数量")
    private Long quantityChange;

    /** 操作后数量 */
    @Excel(name = "操作后数量")
    private Long quantityAfter;

    /** 操作时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "操作时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date transactionTime;

    /** 操作人ID */
    @Excel(name = "操作人ID")
    private String operatedBy;

    /** 应用数据1使用0删除 删除用 */
    @Excel(name = "应用数据1使用0删除 删除用")
    private Long isUsed;

    /** 排序 */
    @Excel(name = "排序")
    private Long sortNo;

    /** 创建日期 */
    @Excel(name = "创建日期")
    private String createUserCode;

    /** 排序号 */
    @Excel(name = "排序号")
    private String updateUserCode;

    @Excel(name = "单价")
    private String unitPrice;

}
