package com.ruoyi.inventory.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.inventory.domain.ReturnOrderItems;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.inventory.domain.ReturnOrders;
import com.ruoyi.inventory.service.IReturnOrdersService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 退库单主Controller
 * 
 * @author ruoyi
 * @date 2025-12-03
 */
@RestController
@RequestMapping("/inventory/return_orders")
public class ReturnOrdersController extends BaseController
{
    @Autowired
    private IReturnOrdersService returnOrdersService;

    /**
     * 查询退库单主列表
     */
    @PreAuthorize("@ss.hasPermi('inventory:return_orders:list')")
    @GetMapping("/list")
    public TableDataInfo list(ReturnOrders returnOrders)
    {
        startPage();
        List<ReturnOrders> list = returnOrdersService.selectReturnOrdersList(returnOrders);
        return getDataTable(list);
    }

    /**
     * 导出退库单主列表
     */
    @PreAuthorize("@ss.hasPermi('inventory:return_orders:export')")
    @Log(title = "退库单主", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ReturnOrders returnOrders)
    {
//        returnOrders.setOrderStatus(2);//导出退库完成的数据
        List<ReturnOrders> list = returnOrdersService.selectReturnOrdersList(returnOrders);
        ExcelUtil<ReturnOrders> util = new ExcelUtil<ReturnOrders>(ReturnOrders.class);
        util.exportExcel(response, list, "退库单主数据");
    }

    /**
     * 获取退库单主详细信息
     */
    @PreAuthorize("@ss.hasPermi('inventory:return_orders:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return success(returnOrdersService.selectReturnOrdersById(id));
    }

    /**
     * 新增退库单主
     */
    @PreAuthorize("@ss.hasPermi('inventory:return_orders:add')")
    @Log(title = "退库单主", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ReturnOrders returnOrders)
    {
        return toAjax(returnOrdersService.insertReturnOrders(returnOrders));
    }

    /**
     * 修改退库单主
     */
    @PreAuthorize("@ss.hasPermi('inventory:return_orders:edit')")
    @Log(title = "退库单主", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ReturnOrders returnOrders)
    {
        return toAjax(returnOrdersService.updateReturnOrders(returnOrders));
    }

    /**
     * 删除退库单主
     */
    @PreAuthorize("@ss.hasPermi('inventory:return_orders:remove')")
    @Log(title = "退库单主", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids)
    {
        return toAjax(returnOrdersService.deleteReturnOrdersByIds(ids));
    }

    /**
     * 确认退库单
     */
    @PreAuthorize("@ss.hasPermi('inventory:return_orders:confirm')")
    @Log(title = "退库确认", businessType = BusinessType.UPDATE)
    @PostMapping("/confirm/{ids}")
    public AjaxResult confirm(@PathVariable String[] ids)
    {
        return toAjax(returnOrdersService.confirmReturnOrdersByIds(ids));
    }
}

